/*
 * Decompiled with CFR 0.152.
 */
public class Sweeper
extends NPC3 {
    public Sweeper(int x, int y, NPC3Thread p, DSMapServer m) {
        this.map = m;
        this.init("a|street|sweeper", "&$!%", x, y, 1, 5, p);
        this.talk = 0;
    }

    public void trigger() {
        int move;
        if (++this.talk == 7) {
            int say = (int)Math.round(Math.random() * 2.0);
            switch (say) {
                case 0: {
                    this.say("What's that over there?");
                    break;
                }
                case 1: {
                    this.send("(Flies buzz around Street Sweeper.");
                    break;
                }
                case 2: {
                    this.say("Hey. What's this?");
                }
            }
            this.talk = 0;
        }
        if ((move = this.getGetItemDir(this.x - 32, this.y - 32)) == -1) {
            move = Sweeper.parent.parent.shortfaceconv[(int)Math.round(Math.random() * 3.0)];
        }
        move = Sweeper.decideDir(move, this);
        this.move(move);
        if (this.map.itemmap[this.x - 32][this.y - 32] != 0) {
            try {
                DSpiresServer cfr_ignored_0 = Sweeper.parent.parent;
                this.send("(Street|Sweeper sweeps up " + DSpiresServer.itemnames[this.map.itemmap[this.x - 32][this.y - 32]] + ".");
            }
            catch (Exception e) {
                this.send("(Street|Sweeper sweeps something up.");
            }
            DSMapServer.placeItemAt(0, this.x - 32, this.y - 32, this.map);
        }
    }

    public int getGetItemDir(int tx, int ty) {
        int xs = tx - 3;
        int xe = tx + 3;
        if (xs < 13) {
            xs = 13;
        } else if (xe > 27) {
            xe = 27;
        }
        int ys = ty - 8;
        int ye = ty + 8;
        if (ys < 8) {
            ys = 8;
        } else if (ye > 66) {
            ye = 66;
        }
        int currnearx = 0;
        int currneary = 0;
        byte canget = 0;
        for (int x = xs; x < xe; ++x) {
            for (int y = ys; y < ye; ++y) {
                if (this.map.itemmap[x][y] == 0) continue;
                try {
                    canget = DSMapServer.parent.itemdefs[this.map.itemmap[x][y]][1];
                }
                catch (Exception e) {
                    canget = 0;
                }
                if (canget == true) continue;
                if (DSMapServer.parent.floorwalk[this.map.tilemap[x][y]] == 1 || Math.abs(tx - x) >= Math.abs(tx - currnearx) && Math.abs(ty - y) >= Math.abs(ty - currneary)) continue;
                currnearx = x;
                currneary = y;
            }
        }
        if (ty % 2 == 0) {
            if (currnearx > tx) {
                if (currneary <= ty) {
                    return 9;
                }
                return 3;
            }
            if (currneary <= ty) {
                return 7;
            }
            return 1;
        }
        if (currnearx < tx) {
            if (currneary <= ty) {
                return 7;
            }
            return 1;
        }
        if (currneary <= ty) {
            return 9;
        }
        return 3;
    }

    protected static int decideDir(int d, NPC3 e) {
        int y;
        int tx = e.x - 32;
        int ty = e.y - 32;
        int x = Sweeper.parent.parent.nextx(tx, ty, d);
        if (e.map.tilemap[x][y = Sweeper.parent.parent.nexty(ty, d)] == 6) {
            return d;
        }
        int t = Sweeper.parent.parent.intRotateLeft(d);
        x = Sweeper.parent.parent.nextx(tx, ty, t);
        if (e.map.tilemap[x][y = Sweeper.parent.parent.nexty(ty, t)] == 6) {
            return t;
        }
        t = Sweeper.parent.parent.intRotateRight(d);
        x = Sweeper.parent.parent.nextx(tx, ty, t);
        if (e.map.tilemap[x][y = Sweeper.parent.parent.nexty(ty, t)] == 6) {
            return t;
        }
        x = Sweeper.parent.parent.nextx(tx, ty, t = Sweeper.parent.parent.intRotateRight(t));
        if (e.map.tilemap[x][y = Sweeper.parent.parent.nexty(ty, t)] == 6) {
            return t;
        }
        return d;
    }
}

