/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;

public class RefreshThread
extends Thread {
    static final int NPC_RESET = 10;
    static final int MAP_RESET = 13;
    int npc_reset_count = 10;
    int map_reset_count = 13;
    DSpiresServer parent;

    public RefreshThread(DSpiresServer p) {
        this.parent = p;
        this.setPriority(1);
    }

    public void run() {
        while (true) {
            try {
                RefreshThread.sleep(3600000L);
                ++this.parent.uptime;
                this.parent.logStats();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.refreshHolders();
            if (--this.npc_reset_count == 0) {
                this.resetNPCs();
            }
            if (--this.map_reset_count != 0) continue;
            this.resetMaps();
        }
    }

    public void refreshHolders() {
        for (int m = 0; m < this.parent.maps.length; ++m) {
            if (this.parent.maps[m].holders == null) continue;
            for (int i = 0; i < this.parent.maps[m].holders.length; i += 4) {
                try {
                    if (this.parent.maps[m].holders[i + 3] > 0) continue;
                    this.parent.maps[m].holders[i + 3] = 1;
                    if (this.parent.maps[m].itemmap[this.parent.maps[m].holders[i]][this.parent.maps[m].holders[i + 1]] == 15) continue;
                    DSMapServer cfr_ignored_0 = this.parent.maps[m];
                    DSMapServer.placeItemAt(15, this.parent.maps[m].holders[i], this.parent.maps[m].holders[i + 1], this.parent.maps[m]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Holders error on map " + (m + 1));
                    e.printStackTrace();
                }
            }
        }
    }

    public void resetNPCs() {
        Enumeration e = this.parent.npc2base.npc2s.elements();
        while (e.hasMoreElements()) {
            NPC2 npc2 = (NPC2)e.nextElement();
            if (!(npc2 instanceof Resetable)) continue;
            ((Resetable)((Object)npc2)).reset();
        }
        for (int m = 0; m < this.parent.maps.length; ++m) {
            DSMapServer map = this.parent.maps[m];
            if (map.npc3s == null) continue;
            for (int i = 0; i < map.npc3s.size(); ++i) {
                NPC3 npc3 = (NPC3)map.npc3s.elementAt(i);
                if (!(npc3 instanceof Resetable)) continue;
                ((Resetable)((Object)npc3)).reset();
            }
        }
        this.npc_reset_count = 10;
    }

    public void resetMaps() {
        for (int i = 0; i < this.parent.maps.length; ++i) {
            DSMapServer m = this.parent.maps[i];
            new MapUpdateThread(m, m.mapname + ".dsmap", m.mapname + ".ini");
            try {
                RefreshThread.sleep(200L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.map_reset_count = 13 + (int)(Math.round(Math.random() * 5.0) - 2L);
    }
}

