/*
 * Decompiled with CFR 0.152.
 */
public class Group {
    static final int MAX_GROUP_SIZE = 4;
    DSpiresSocket leader;
    DSpiresSocket[] members;
    char[] positions;
    int[] shapes;
    boolean[] moved;

    public Group(DSpiresSocket l) {
        this.leader = l;
        this.leader.groupstat = 2;
        this.members = new DSpiresSocket[4];
        this.positions = new char[8];
        this.moved = new boolean[4];
        this.shapes = new int[4];
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = '\u0001';
            if (i >= 4) continue;
            this.moved[i] = false;
        }
    }

    public void addMember(DSpiresSocket s) {
        int n = -1;
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] != null) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.groupSend("(" + s.name + " has joined the group.");
            this.members[n] = s;
            this.moved[n] = false;
            s.groupstat = 1;
            s.stateCheck |= 4;
            s.Group = this;
            s.pSend("(You've joined " + this.leader.name + "'s group.");
        } else {
            s.pSend("(The group is full.");
        }
    }

    public void removeMember(DSpiresSocket s) {
        int i;
        int count = 0;
        for (i = 0; i < 4; ++i) {
            if (this.members[i] != s) continue;
            this.members[i] = null;
            this.groupSend("(" + s.name + " has left the group.");
            s.groupstat = 0;
            s.Group = null;
            s.stateCheck ^= 4;
            s.pSend("(You have left " + this.leader.name + "'s group.");
            break;
        }
        for (i = 0; i < 4; ++i) {
            if (this.members[i] != null) continue;
            ++count;
        }
        if (count == 4) {
            try {
                this.leader.Group = null;
                this.leader.groupstat = 0;
                this.leader = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void groupSend(String message) {
        try {
            this.leader.pSend(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] == null) continue;
            try {
                this.members[i].pSend(message);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String groupList() {
        String retval = "" + this.leader.name;
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] == null) continue;
            retval = retval + ", " + this.members[i].name;
        }
        return retval + ".";
    }

    public void moveGroup(char bx, char by, int shape) {
        System.arraycopy(this.positions, 0, this.positions, 2, this.positions.length - 2);
        System.arraycopy(this.shapes, 0, this.shapes, 1, 3);
        this.positions[0] = bx;
        this.positions[1] = by;
        this.shapes[0] = shape;
        int poscount = 0;
        int thefacing = this.leader.facing;
        this.groupSend("~");
        this.leader.pSend("@" + this.leader.cx + "" + this.leader.cy);
        DSMapServer cfr_ignored_0 = this.leader.map;
        DSMapServer.playerMoveBroadcast(this.leader.visishape, this.leader.colorstring, this.leader.cx, this.leader.cy, bx, by, this.leader, this.leader.map);
        for (int i = 0; i < 4; ++i) {
            int they;
            int thex;
            if (this.members[i] == null) continue;
            if (this.positions[poscount * 2] == '\u0001') break;
            DSpiresSocket member = this.members[i];
            if (member.stateCheck != 4) {
                member.doStateChecker("mg1");
            }
            bx = member.cx;
            by = member.cy;
            if (this.moved[i]) {
                member.facing = thefacing;
                thex = this.positions[poscount * 2] - 32;
                they = this.positions[poscount * 2 + 1] - 32;
            } else {
                DSpiresSocket tocompare = this.leader;
                if (i != 0) {
                    int n;
                    for (n = i - 1; n >= 0 && this.members[n] == null; --n) {
                    }
                    if (n >= 0) {
                        tocompare = this.members[n];
                    }
                }
                thex = DSpiresSocket.parent.nextx(tocompare.x, tocompare.y, DSpiresSocket.parent.faceopp[tocompare.facing]);
                they = DSpiresSocket.parent.nexty(tocompare.y, DSpiresSocket.parent.faceopp[tocompare.facing]);
                DSMapServer cfr_ignored_1 = this.leader.map;
                if (!DSMapServer.canWalk(thex, they, this.leader.map)) {
                    ++poscount;
                    continue;
                }
                this.moved[i] = true;
            }
            member.setPosition(thex, they);
            member.pSend("@" + member.cx + "" + member.cy);
            DSMapServer cfr_ignored_2 = member.map;
            DSMapServer.playerMoveBroadcast(this.shapes[poscount], member.colorstring, member.cx, member.cy, bx, by, member, this.leader.map);
            if (DSpiresSocket.parent.itemdefs[member.map.itemmap[thex][they]][4] == 1) {
                member.stepOnItem(thex, they, member.map.itemmap[thex][they], 0);
            }
            if (member.map.itemmap[thex][they] != member.pfooti) {
                member.setFeet(member.map.itemmap[thex][they]);
            }
            if (member.map.walktrig) {
                member.map.walkTrigger(member);
            }
            ++poscount;
        }
        this.groupSend("=");
    }

    public void disbandGroup() {
        this.groupSend("(" + this.leader.name + " disbands the group.");
        this.leader.Group = null;
        this.leader.groupstat = 0;
        this.leader = null;
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] == null) continue;
            this.members[i].Group = null;
            this.members[i].groupstat = 0;
            DSpiresSocket cfr_ignored_0 = this.members[i];
            this.members[i].stateCheck ^= 4;
            this.members[i] = null;
        }
    }

    public void groupChangeMap(DSMapServer map) {
        this.reset();
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] == null) continue;
            DSMapServer cfr_ignored_0 = this.leader.map;
            DSMapServer.playerPlaceBroadcast(0, this.members[i].colorstring, this.members[i].cx, this.members[i].cy, this.members[i], this.leader.map);
            this.members[i].setPosition(this.leader.cx - 32, this.leader.cy - 32);
            this.members[i].facing = this.leader.facing;
            this.members[i].changeMap(map, 1, 0, 0);
        }
    }

    public void kickMember(String name) {
        name = name.toLowerCase();
        for (int i = 0; i < 4; ++i) {
            if (this.members[i] == null || !this.members[i].name.toLowerCase().equals(name)) continue;
            this.removeMember(this.members[i]);
            break;
        }
    }

    public void transpose() {
        int m;
        int[][] coords = new int[5][2];
        DSpiresSocket[] everyone = new DSpiresSocket[5];
        DSpiresServer p = DSpiresSocket.parent;
        DSMapServer themap = this.leader.map;
        this.groupSend("[!" + this.leader.name + " transposes the group.");
        everyone[0] = this.leader;
        int i = 1;
        for (m = 0; m < 4; ++m) {
            if (this.members[m] == null) continue;
            everyone[i++] = this.members[m];
        }
        for (i = 0; i < 5; ++i) {
            coords[i][0] = -1;
        }
        coords[0][0] = this.leader.x;
        coords[0][1] = this.leader.y;
        i = 1;
        for (m = 0; m < 4; ++m) {
            if (this.members[m] == null) continue;
            coords[i][0] = this.members[m].x;
            coords[i++][1] = this.members[m].y;
        }
        DSMapServer.limitedBroadcast("~", coords[0][0], coords[0][1], themap);
        m = i - 1;
        for (i = 0; i < m && m > -1 && i < 5; --m, ++i) {
            DSpiresSocket it = everyone[m];
            if (m == i) {
                it.facing = p.faceopp[it.facing];
                it.doStateChecker("mg1");
                DSMapServer.playerPlaceBroadcast(DSpiresServer.longShapeStart[1][it.facing - 1], it.colorstring, it.cx, it.cy, it, themap);
                break;
            }
            it.facing = p.faceopp[it.facing];
            it.doStateChecker("mg1");
            it.setPosition(coords[i][0], coords[i][1]);
            DSMapServer.playerPlaceBroadcast(DSpiresServer.longShapeStart[1][it.facing - 1], it.colorstring, it.cx, it.cy, it, themap);
            it = everyone[i];
            it.facing = p.faceopp[it.facing];
            it.doStateChecker("mg1");
            it.setPosition(coords[m][0], coords[m][1]);
            DSMapServer.playerPlaceBroadcast(DSpiresServer.longShapeStart[1][it.facing - 1], it.colorstring, it.cx, it.cy, it, themap);
        }
        DSMapServer.limitedBroadcast("=", coords[0][0], coords[0][1], themap);
    }
}

