/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Enemy
extends PlayerDataObject {
    static byte[][] shapestart;
    DSMapServer map;
    int currshape;
    int facing;
    int mstate;
    int hp;
    int tilltrig;
    int ie;
    int move;
    int killed = 0;
    char ox;
    char oy;
    boolean nullwhendie;
    boolean special_trig = false;
    boolean special_die = false;
    EIE me;

    public Enemy() {
    }

    public Enemy(DSpiresServer s) {
        shapestart = DSpiresServer.longShapeStart;
    }

    public Enemy(int eie, int x, int y, boolean nwd, DSMapServer m) {
        try {
            if (m.enemybase.enemies.size() >= 40) {
                return;
            }
            if (m == null) {
                throw new NullPointerException("null map");
            }
            this.init(eie, x, y, nwd, m);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void init(int eie, int x, int y, boolean nwd, DSMapServer m) {
        this.map = m;
        this.x = DSMapServer.parent.toDSChar(x);
        this.y = DSMapServer.parent.toDSChar(y);
        this.ox = this.x;
        this.oy = this.y;
        this.me = DSMapServer.parent.enemyIndex[eie];
        this.nullwhendie = nwd;
        this.hp = this.me.maxhp;
        this.currshape = 2;
        this.mstate = 1;
        this.ie = eie;
        this.tilltrig = this.me.maxtilltrig;
        this.colorstring = this.me.colorstring;
        DSMapServer.pdoInit(this, 2 + this.mstate, m);
    }

    public void mytrigger() {
    }

    public synchronized boolean isReady() {
        if (--this.tilltrig <= 0) {
            this.tilltrig = this.me.maxtilltrig;
            return true;
        }
        return false;
    }

    public synchronized void trigger() {
        if (this.killed == 0) {
            int f;
            this.move = this.getNearestPlayerDir(this.x - 32, this.y - 32, this.map);
            boolean domore = true;
            if (this.move == -1) {
                this.move = DSMapServer.parent.shortfaceconv[(int)Math.round(Math.random() * 3.0)];
            }
            int tx = DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.move);
            int ty = DSMapServer.parent.nexty(this.y - 32, this.move);
            if (this.me.projectile) {
                if (DSMapServer.canWalk(tx, ty, this.map)) {
                    this.move(this.move);
                    new DSBullet(this.me.projectile_item, this.x - 32, this.y - 32, this.facing, this.me.projectile_length, this.map, this, DSMapServer.parent);
                    return;
                }
            }
            if (this.map.playermap[tx][ty] != 0) {
                f = this.attack(tx, ty);
                if (f == 1) {
                    domore = false;
                    this.move(this.move);
                } else if (f == 2) {
                    return;
                }
            }
            if (domore) {
                this.move = this.decideDir(this.move);
                tx = DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.move);
                ty = DSMapServer.parent.nexty(this.y - 32, this.move);
                if (this.map.playermap[tx][ty] != 0 && (f = this.attack(tx, ty)) == 1) {
                    domore = false;
                    this.move(this.move);
                }
                this.move(this.move);
                if (domore) {
                    tx = DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.move);
                    ty = DSMapServer.parent.nexty(this.y - 32, this.move);
                    if (this.map.playermap[tx][ty] != 0) {
                        this.attack(tx, ty);
                    }
                }
            }
        } else if (--this.killed == 0) {
            this.mstate = 1;
            DSMapServer.pdoInit(this, 2 + this.mstate, this.map);
            DSMapServer.pdoPlace(this, 3, this.colorstring, this.x, this.y, this.map);
        }
    }

    public void move(int dir) {
        this.facing = dir;
        this.mstate *= -1;
        this.currshape = shapestart[this.me.shapecat][this.facing - 1] + this.mstate;
        int tx = DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.facing);
        int ty = DSMapServer.parent.nexty(this.y - 32, this.facing);
        if (!DSMapServer.canWalk(tx, ty, this.map) || this.map.playermap[tx][ty] != 0) {
            DSMapServer.pdoPlace(this, this.currshape, this.colorstring, this.x, this.y, this.map);
        } else {
            DSMapServer.pdoMove(this, this.currshape, this.colorstring, (char)(tx + 32), (char)(ty + 32), this.x, this.y, this.map);
        }
    }

    public int getNearestPlayerDir(int x, int y, DSMapServer m) {
        if (this.map.sockets.size() == 0) {
            return -1;
        }
        int currnearx = 0;
        int currneary = 0;
        int tx = -1;
        Enumeration e = this.map.sockets.elements();
        while (e.hasMoreElements()) {
            try {
                DSpiresSocket s = (DSpiresSocket)e.nextElement();
                if (s.bitIsMarked(s.stateCheck, 1)) continue;
                tx = s.x;
                int ty = s.y;
                if (Math.abs(x - tx) + Math.abs(y - ty) >= Math.abs(x - currnearx) + Math.abs(y - currneary)) continue;
                currnearx = tx;
                currneary = ty;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (tx == -1) {
            return -1;
        }
        if (y % 2 == 0) {
            if (currnearx > x) {
                if (currneary <= y) {
                    return 9;
                }
                return 3;
            }
            if (currneary <= y) {
                return 7;
            }
            return 1;
        }
        if (currnearx < x) {
            if (currneary <= y) {
                return 7;
            }
            return 1;
        }
        if (currneary <= y) {
            return 9;
        }
        return 3;
    }

    public int decideDir(int d) {
        int tx = this.x - 32;
        int ty = this.y - 32;
        int x = DSMapServer.parent.nextx(tx, ty, d);
        int y = DSMapServer.parent.nexty(ty, d);
        if (DSMapServer.canWalk(x, y, this.map) || this.map.playermap[x][y] != 0) {
            return d;
        }
        int t = DSMapServer.parent.intRotateLeft(d);
        x = DSMapServer.parent.nextx(tx, ty, t);
        y = DSMapServer.parent.nexty(ty, t);
        if (DSMapServer.canWalk(x, y, this.map) || this.map.playermap[x][y] != 0) {
            return t;
        }
        t = DSMapServer.parent.intRotateRight(d);
        x = DSMapServer.parent.nextx(tx, ty, t);
        y = DSMapServer.parent.nexty(ty, t);
        if (DSMapServer.canWalk(x, y, this.map) || this.map.playermap[x][y] != 0) {
            return t;
        }
        t = DSMapServer.parent.intRotateRight(t);
        x = DSMapServer.parent.nextx(tx, ty, t);
        y = DSMapServer.parent.nexty(ty, t);
        if (DSMapServer.canWalk(x, y, this.map) || this.map.playermap[x][y] != 0) {
            return t;
        }
        return d;
    }

    public static String assembleAttackString(String emessage, String ename, String pname) {
        String retval = "";
        char[] buffer = emessage.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == '%') {
                switch (buffer[i + 1]) {
                    case '1': {
                        retval = retval + ename;
                        ++i;
                        break;
                    }
                    case '2': {
                        retval = retval + pname;
                        ++i;
                    }
                }
                continue;
            }
            retval = retval + buffer[i];
        }
        return retval;
    }

    public void attack(int dir) {
        this.attack(DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.facing), DSMapServer.parent.nexty(this.y - 32, this.facing));
    }

    public int attack(int x, int y) {
        DSpiresSocket c = this.findSocketAtPosToAttack(DSMapServer.parent.toDSChar(x), DSMapServer.parent.toDSChar(y), this.map);
        if (c != null) {
            if (this.me.spell > -1) {
                c.sightSend(DSpiresSocket.parent.assembleSpellString(this.me.spell, x, y));
            }
            String emessage = Enemy.assembleAttackString(this.me.attack, this.me.name, c.name);
            if (this.me.weapon.mindam == -1) {
                c.sightSendAttacks("[#" + emessage, null);
                return 1;
            }
            int damage = DSpiresSocket.W2A(this.me.weapon, c.armorO);
            if (damage < 1) {
                DSMapServer cfr_ignored_0 = c.map;
                if (DSMapServer.parent.dice(1, 6) == 1) {
                    emessage = "[#While dodging, " + c.name + " slips and falls!";
                    damage = 1;
                } else {
                    emessage = "[#" + c.name + " dodges " + this.me.name + "'s pathetic attack!";
                }
            } else {
                emessage = "[\"" + emessage;
            }
            if (!c.doDamageToPlayer(damage)) {
                c.sightSendAttacks(emessage + " (" + damage + ")", null);
                c.pSend("$H" + c.hp);
            } else {
                c.sightSendAttacks("[\"" + this.me.name + " did slay " + c.name + "!", null);
                DSMapServer cfr_ignored_1 = c.map;
                DSMapServer.parent.channelBroadcast(this.me.name + " did slay " + c.name + "!", 4);
                c.killMe(true);
            }
            return 1;
        }
        return 0;
    }

    public synchronized void die() {
        if (this.special_die) {
            this.whendie();
        }
        DSMapServer.pdoPlace(this, 0, "", this.x, this.y, this.map);
        BagOStuff b = DSMapServer.addBag(this.x - 32, this.y - 32, this.me.gold, new int[0], this.map);
        for (int i = 0; i < this.me.drop.length; ++i) {
            if (this.me.drop[i] == 0 || (int)Math.round(Math.random() * 2.0) > 1) continue;
            BagOStuff.addItem(this.me.drop[i], b, this.map);
        }
        if (this.nullwhendie || this.ie == 36) {
            this.map.removeEnemy(this);
            return;
        }
        this.x = this.ox;
        this.y = this.oy;
        this.hp = this.me.maxhp;
        this.killed = 5;
    }

    public void whendie() {
    }

    public boolean doDamageToEnemy(int damage) {
        return (this.hp -= damage) <= 0;
    }

    public void damage(DSpiresSocket s, boolean attackbydir) {
        int damage = DSpiresSocket.W2A(s.weaponO, this.me.armor) + s.extraDamage(this.x - 32, this.y - 32);
        if (damage > 0) {
            String funstring = damage > 12 ? "0wns" : (damage > 9 ? "massacres" : (damage > 6 ? "bashes" : (damage > 2 ? "did smite" : "pricks")));
            s.sightSendAttacks("[\"" + s.name + " " + funstring + " " + this.me.name + "! (" + damage + ")", null);
        } else if (DSMapServer.parent.dice(1, 5) == 1) {
            s.sightSendAttacks("[$While dodging, " + this.me.name + " slips and falls! (1)", null);
            damage = 1;
        } else {
            s.sightSendAttacks("[$" + this.me.name + " dodges " + s.name + "'s pathetic attack! (0)", null);
        }
        if (this.doDamageToEnemy(damage)) {
            s.updateAlign(this.me.align);
            s.sightSendAttacks("!4", null);
            s.sightSendAttacks("[\"" + s.name + " did slay " + this.me.name + "!", null);
            if (this instanceof i1Enemy) {
                ((i1Enemy)this).die();
            } else {
                this.die();
            }
            return;
        }
        if (attackbydir) {
            if (this instanceof i1Enemy) {
                ((i1Enemy)this).move(DSMapServer.parent.faceopp[s.facing]);
                if (this.me.projectile) {
                    if (DSMapServer.canWalk(DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.facing), DSMapServer.parent.nexty(this.y - 32, this.facing), this.map)) {
                        new DSBullet(this.me.projectile_item, this.x - 32, this.y - 32, this.facing, this.me.projectile_length, this.map, this, DSMapServer.parent);
                        return;
                    }
                }
            } else if (Math.round(Math.random()) == 0L) {
                this.move(DSMapServer.parent.shortfaceconv[(int)Math.round(Math.random() * 3.0)]);
            } else {
                this.move(DSMapServer.parent.faceopp[s.facing]);
                if (this.me.projectile) {
                    if (DSMapServer.canWalk(DSMapServer.parent.nextx(this.x - 32, this.y - 32, this.facing), DSMapServer.parent.nexty(this.y - 32, this.facing), this.map)) {
                        new DSBullet(this.me.projectile_item, this.x - 32, this.y - 32, this.facing, this.me.projectile_length, this.map, this, DSMapServer.parent);
                        return;
                    }
                }
            }
            this.attack(DSMapServer.parent.faceopp[s.facing]);
        } else {
            this.attack(s.x, s.y);
        }
    }

    public DSpiresSocket findSocketAtPosToAttack(char x, char y, DSMapServer m) {
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            if (c.cx != x || c.cy != y) continue;
            if (c.bitIsMarked(c.stateCheck, 1)) continue;
            if (c.bitIsMarked(c.stateCheck, 8) && c.map.safemap || c.colorstring.charAt(3) == ' ') continue;
            return c;
        }
        return null;
    }
}

