/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DSMapServer {
    static DSpiresServer parent;
    DSMapServer parentmap;
    static final int mwidth = 52;
    static final int mheight = 100;
    static final int items = 346;
    static final int MAX_ENEMIES = 40;
    static String[] graffitti;
    Vector sockets;
    Vector pdos;
    Vector holes;
    Vector bags;
    String[] readables;
    String mapname;
    String entrytext;
    String owner;
    int[][] tilemap;
    int[][] itemmap;
    int[][] oitemmap;
    int[][] playermap;
    int[] holders = null;
    int[] exits = new int[]{-2, -2, -2, -2};
    int[] attacktiles = new int[]{0, 0, 0, 0, 0};
    int stamval = -1;
    int maxUploads = 0;
    short mapnumber;
    short xstart = (short)26;
    short ystart = (short)41;
    short diemap = 0;
    short fountainx = (short)-1;
    short fountainy = (short)-1;
    boolean safemap = false;
    boolean walktrig = false;
    boolean allowupload = false;
    boolean allowcombat = false;
    boolean removingenemy = false;
    Shop[] shops;
    Vector npc3s;
    Portal[] portals;
    MapEnemyThread enemybase;
    Vector laptops;

    public DSMapServer() {
    }

    public DSMapServer(String mname, int mnumber) {
        this.mapname = mname;
        this.mapnumber = (short)mnumber;
        DSMapServer.init(this.mapname + ".dsmap", this);
    }

    public DSMapServer(String mname, String oname, int mnumber) {
        this.mapname = mname;
        this.mapnumber = (short)mnumber;
        DSMapServer.init(this.mapname + ".dsmap", oname, this);
    }

    protected static void init(String mapfile, DSMapServer m) {
        m.sockets = new Vector();
        m.pdos = new Vector();
        m.tilemap = new int[52][102];
        m.itemmap = new int[52][102];
        m.playermap = new int[52][102];
        m.oitemmap = new int[52][102];
        DSMapServer.getMapData("../maps/" + mapfile, m);
    }

    protected static void init(String mapfile, String oimapfile, DSMapServer m) {
        DSMapServer.init(oimapfile, m);
        DSMapServer.getIMapData("../maps/" + mapfile, m);
    }

    public void walkTrigger(DSpiresSocket c) {
    }

    protected static void getMapData(String mapname, DSMapServer m) {
        try {
            int y;
            int x;
            FileInputStream i = new FileInputStream(new File(mapname));
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    m.tilemap[x][y] = parent.decode(i.read(), i.read());
                    if (m.tilemap[x][y] <= DSMapServer.parent.floorwalk.length && m.tilemap[x][y] >= 0) continue;
                    m.tilemap[x][y] = 0;
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    m.itemmap[x][y] = parent.decode(i.read(), i.read());
                    if (m.itemmap[x][y] > 346 || m.itemmap[x][y] < 0) {
                        m.itemmap[x][y] = 0;
                    }
                    m.oitemmap[x][y] = m.itemmap[x][y];
                }
            }
            i.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Exception read_map_from_reader(Reader i, DSMapServer m, DSpiresSocket c) {
        try {
            int y;
            int x;
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    m.tilemap[x][y] = parent.decode(i.read() - 32, i.read() - 32);
                    if (m.tilemap[x][y] <= DSMapServer.parent.floorwalk.length && m.tilemap[x][y] >= 0) continue;
                    m.tilemap[x][y] = 0;
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    m.itemmap[x][y] = parent.decode(i.read() - 32, i.read() - 32);
                    if (m.itemmap[x][y] > 346 || m.itemmap[x][y] < 0) {
                        m.itemmap[x][y] = 0;
                    }
                    m.oitemmap[x][y] = m.itemmap[x][y];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e;
        }
        return null;
    }

    protected static void getIMapData(String mapname, DSMapServer m) {
        try {
            int y;
            int x;
            FileInputStream i = new FileInputStream(new File(mapname));
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    i.skip(2L);
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    m.itemmap[x][y] = parent.decode(i.read(), i.read());
                    if (m.itemmap[x][y] <= 346 && m.itemmap[x][y] >= 0) continue;
                    m.itemmap[x][y] = 0;
                }
            }
            i.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean canWalk(int x, int y, DSMapServer m) {
        try {
            if (m.playermap[x][y] != 0 || DSMapServer.parent.itemdefs[m.itemmap[x][y]][0] != 0 || DSMapServer.parent.floorwalk[m.tilemap[x][y]] != 0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected static boolean dsPinR2(int cx, int cy, int x, int y) {
        return cy % 2 == 0 ? DSMapServer.even_dsPinR2(cx, cy, x, y) : DSMapServer.odd_dsPinR2(cx, cy, x, y);
    }

    protected static boolean even_dsPinR2(int cx, int cy, int x, int y) {
        return x >= cx - 3 && x <= cx + 3 && y >= cy - 8 && y <= cy + 8 && (x != cx - 3 || y % 2 != 1);
    }

    protected static boolean odd_dsPinR2(int cx, int cy, int x, int y) {
        return x >= cx - 3 && x <= cx + 3 && y >= cy - 8 && y <= cy + 8 && (x != cx + 3 || y % 2 != 0);
    }

    protected static void playerMoveBroadcast(int shape, String colorstring, char x, char y, char x2, char y2, DSpiresSocket s, DSMapServer m) {
        String tosend = "<" + x + "" + y + "" + parent.toDSChar(shape) + "" + colorstring + "" + x2 + "" + y2 + " ";
        x = (char)s.x;
        y = (char)s.y;
        x2 = (char)(x2 - 32);
        y2 = (char)(y2 - 32);
        m.playermap[x][y] = shape;
        m.playermap[x2][y2] = 0;
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            boolean inrectshape = DSMapServer.dsPinR2(c.x, c.y, x, y);
            boolean inrectblank = DSMapServer.dsPinR2(c.x, c.y, x2, y2);
            if (inrectshape && inrectblank) {
                c.pSend(tosend);
                continue;
            }
            if (!inrectshape && inrectblank) {
                c.pSend("<" + (char)(x2 + 32) + "" + (char)(y2 + 32) + " ");
                c.sight.removeElement(s);
                s.pSend("<" + c.cx + "" + c.cy + " ");
                s.sight.removeElement(c);
                continue;
            }
            if (!inrectshape || inrectblank) continue;
            c.pSend("<" + (char)(x + 32) + "" + (char)(y + 32) + "" + parent.toDSChar(shape) + "" + colorstring);
            c.sight.addElement(s);
            s.pSend("<" + c.cx + "" + c.cy + "" + parent.toDSChar(c.visishape) + "" + c.colorstring);
            s.sight.addElement(c);
        }
        if (m.pdos.size() > 0) {
            DSMapServer.pdoForPlayerMove(x, y, x2, y2, s);
        }
    }

    protected static void playerPlaceBroadcast(int shape, String colorstring, char x, char y, DSpiresSocket s, DSMapServer m) {
        m.playermap[s.x][s.y] = shape;
        String tosend = "<" + x + "" + y + "" + parent.toDSChar(shape) + "" + colorstring;
        if (shape == 0 && !colorstring.equals("")) {
            s.sight.removeElement(s);
        }
        Enumeration e = s.sight.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            c.pSend(tosend);
        }
        if (shape == 0 && !colorstring.equals("")) {
            DSMapServer.clearSight(s);
        }
    }

    protected static void clearSight(DSpiresSocket s) {
        Enumeration e = s.sight.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            c.sight.removeElement(s);
        }
        s.sight.removeAllElements();
    }

    protected static void itemRecover(int item, DSMapServer m) {
        int y;
        int x;
        boolean found = false;
        if (item <= 346) {
            block0: for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    if (m.oitemmap[x][y] != item || m.itemmap[x][y] != 0) continue;
                    found = true;
                    DSMapServer.placeItemAt(item, x, y, m);
                    continue block0;
                }
            }
        }
        if (!found) {
            x = (int)Math.round(Math.random() * 51.0);
            y = (int)Math.round(Math.random() * 99.0);
            while (!DSMapServer.canWalk(x, y, m) || m.itemmap[x][y] != 0) {
                x = (int)Math.round(Math.random() * 51.0);
                y = (int)Math.round(Math.random() * 99.0);
            }
            if (item <= 346) {
                DSMapServer.placeItemAt(item, x, y, m);
            } else {
                DSMapServer.addAnimal(item, x, y, m);
            }
        }
    }

    protected static void broadcast(String message, DSMapServer m) {
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            try {
                DSpiresSocket c = (DSpiresSocket)e.nextElement();
                c.pSend(message);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    protected static void placeItemAt(int item, int x, int y, DSMapServer m) {
        m.itemmap[x][y] = item;
        DSMapServer.broadcast(">" + parent.toDSChar(x) + "" + parent.toDSChar(y) + "" + parent.encode(item), m);
        if (item > 346 || item == 143) {
            DSMapServer.addAnimal(item, x, y, m);
        }
    }

    protected static void limitedBroadcast(String message, int x, int y, DSMapServer m) {
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            if (!DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x, y)) continue;
            c.pSend(message);
        }
    }

    protected static void doBall(int dir, int x, int y, int item, DSMapServer m) {
        int tx = parent.nextx(x, y, dir);
        int ty = parent.nexty(y, dir);
        boolean ok = false;
        for (int i = 0; i < 4; ++i) {
            if (DSMapServer.canWalk(tx, ty, m) && m.itemmap[tx][ty] == 0) {
                ok = true;
                break;
            }
            if ((dir -= 2) < 1) {
                dir = 9;
            } else if (dir == 5) {
                dir = 3;
            }
            tx = parent.nextx(x, y, dir);
            ty = parent.nexty(y, dir);
        }
        if (ok) {
            DSMapServer.broadcast(">" + (char)(tx + 32) + "" + (char)(ty + 32) + "" + parent.encode(item) + "" + (char)(x + 32) + "" + (char)(y + 32) + "  ", m);
            m.itemmap[tx][ty] = item;
            m.itemmap[x][y] = 0;
            DSMapServer.limitedBroadcast("!1", x, y, m);
        } else if (item == 8) {
            DSMapServer.limitedBroadcast(parent.assembleSpellString(16, x, y), x, y, m);
            DSMapServer.placeItemAt(0, x, y, m);
        }
    }

    protected static void makeBalls(DSMapServer m) {
        for (int x = 0; x < 52; ++x) {
            for (int y = 0; y < 100; ++y) {
                if (m.tilemap[x][y] != 2 || m.itemmap[x][y] != 0) continue;
                DSMapServer.placeItemAt(8, x, y, m);
            }
        }
        DSMapServer.broadcast("!2", m);
    }

    protected static void doWhisper(String incoming, DSpiresSocket s) {
        try {
            String thename = incoming.substring(2, incoming.indexOf(" "));
            String message = incoming.substring(incoming.indexOf(" ") + 1);
            DSpiresSocket c = s.getSocketByNearestString(thename.toLowerCase());
            if (c != null) {
                if (message.startsWith(":") && message.length() > 2) {
                    message = s.name + (Character.isLetterOrDigit(message.charAt(1)) ? " " : "") + message.substring(1);
                }
                c.pSend("[(~ " + s.name + " whispers, " + '\"' + message + '\"' + " to you.");
                if (c.invis) {
                    s.pSend("(* There's no one on DragonSpires with the name '" + thename + "'.");
                } else {
                    s.pSend("[(You whisper, \"" + message + '\"' + " to " + c.name + (c.bitIsMarked(c.stateCheck, 8) ? ", but " + c.name + " is in BRB mode." : "."));
                }
            }
        }
        catch (Exception e) {
            s.pSend("(Whispers must have a name and a message.");
        }
    }

    protected static void addAnimal(int animal, int x, int y, DSMapServer map) {
        if (346 < animal && animal <= 354) {
            DSMapServer.parent.animalbase.animals.addElement(new Bunny(x, y, map, DSMapServer.parent.animalbase));
        } else if (354 < animal && animal <= 362) {
            DSMapServer.parent.animalbase.animals.addElement(new Snail(x, y, map, DSMapServer.parent.animalbase));
        } else if (362 < animal && animal <= 370) {
            DSMapServer.parent.animalbase.animals.addElement(new Lizard(x, y, map, DSMapServer.parent.animalbase));
        } else if (378 < animal && animal <= 386) {
            DSMapServer.parent.animalbase.animals.addElement(new Squirrel(x, y, map, DSMapServer.parent.animalbase));
        } else if (378 < animal && animal <= 394) {
            DSMapServer.parent.animalbase.animals.addElement(new Crow(x, y, map, DSMapServer.parent.animalbase));
        } else if (animal == 143) {
            DSMapServer.parent.animalbase.animals.addElement(new Balloon(x, y, map, DSMapServer.parent.animalbase));
        }
    }

    public static Enemy findEnemyAtPos(int x, int y, DSMapServer m) {
        if (m.enemybase != null) {
            Enumeration e = m.enemybase.enemies.elements();
            while (e.hasMoreElements()) {
                Enemy c = (Enemy)e.nextElement();
                if (c.killed != 0 || c.x - 32 != x || c.y - 32 != y) continue;
                return c;
            }
        }
        return null;
    }

    public synchronized void addEnemy(Enemy e) {
        if (this instanceof BasicMap) {
            return;
        }
        if (this.enemybase.enemies.size() >= 40) {
            return;
        }
        this.enemybase.enemies.addElement(e);
        boolean ass = this.enemybase.isAlive();
        try {
            if (!ass) {
                MapEnemyThread ho = new MapEnemyThread(this);
                ho.enemies = this.enemybase.enemies;
                this.enemybase = ho;
                this.enemybase.start();
            }
        }
        catch (IllegalThreadStateException ex) {
            System.err.println("");
            System.err.println("Map=" + (this.mapnumber + 1));
            System.err.println("ass=" + ass);
            System.err.println("enemycount=" + this.enemybase.enemies.size());
            ex.printStackTrace();
            System.err.println("");
        }
    }

    public void addEnemy(int type, int x, int y, boolean nwd) {
        Enemy e = DSMapServer.parent.enemyIndex[type].is_item ? new i1Enemy(type, x, y, nwd, this) : new Enemy(type, x, y, nwd, this);
        this.addEnemy(e);
    }

    public synchronized void removeEnemy(Enemy e) {
        this.enemybase.enemies.removeElement(e);
    }

    protected static void pdoPlace(PlayerDataObject pdo, int shape, String colorstring, char x, char y, DSMapServer m) {
        if (shape == 0) {
            Enumeration e = m.pdos.elements();
            while (e.hasMoreElements()) {
                PlayerDataObject tpdo = (PlayerDataObject)e.nextElement();
                if (tpdo != pdo) continue;
                m.pdos.removeElement(pdo);
                break;
            }
        }
        DSMapServer.pdoPlaceBroadcast(shape, colorstring, x, y, m);
    }

    protected static void pdoMove(PlayerDataObject pdo, int shape, String colorstring, char x, char y, char x2, char y2, DSMapServer m) {
        String tosend = "<" + x + "" + y + "" + parent.toDSChar(shape) + "" + colorstring + "" + x2 + "" + y2 + " ";
        m.playermap[x - 32][y - 32] = shape;
        m.playermap[x2 - 32][y2 - 32] = 0;
        pdo.x = x;
        pdo.y = y;
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            boolean inrectshape = DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x - 32, y - 32);
            boolean inrectblank = DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x2 - 32, y2 - 32);
            if (inrectshape && inrectblank) {
                c.pSend(tosend);
                continue;
            }
            if (!inrectshape && inrectblank) {
                c.pSend("<" + x2 + "" + y2 + " ");
                continue;
            }
            if (!inrectshape || inrectblank) continue;
            c.pSend("<" + x + "" + y + "" + parent.toDSChar(shape) + "" + colorstring);
        }
    }

    protected static void pdoForPlayerMove(int x, int y, int x2, int y2, DSpiresSocket s) {
        Enumeration e = s.map.pdos.elements();
        while (e.hasMoreElements()) {
            PlayerDataObject pdo = (PlayerDataObject)e.nextElement();
            int somex = pdo.x - 32;
            int somey = pdo.y - 32;
            boolean inrectshape = DSMapServer.dsPinR2(x, y, somex, somey);
            boolean inrectblank = DSMapServer.dsPinR2(x2, y2, somex, somey);
            if (!inrectshape && inrectblank) {
                s.pSend("<" + pdo.x + "" + pdo.y + " ");
                continue;
            }
            if (!inrectshape || inrectblank) continue;
            s.pSend("<" + pdo.x + "" + pdo.y + "" + parent.toDSChar(s.map.playermap[somex][somey]) + "" + pdo.colorstring);
        }
    }

    protected static void playerPlaceBroadcastWithRefresh(int shape, String colorstring, int x, int y, DSpiresSocket s, DSMapServer m) {
        String tosend = "<" + s.cx + "" + s.cy + "" + parent.toDSChar(shape) + "" + colorstring;
        m.playermap[x][y] = shape;
        s.sight.removeAllElements();
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            try {
                DSpiresSocket c = (DSpiresSocket)e.nextElement();
                if (!DSMapServer.dsPinR2(c.x, c.y, x, y)) continue;
                if (s != c) {
                    c.sight.addElement(s);
                }
                c.pSend(tosend);
                s.sight.addElement(c);
                s.pSend("<" + c.cx + "" + c.cy + "" + parent.toDSChar(c.visishape) + "" + c.colorstring);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (m.pdos.size() > 0) {
            e = m.pdos.elements();
            while (e.hasMoreElements()) {
                PlayerDataObject pdo = (PlayerDataObject)e.nextElement();
                if (!DSMapServer.dsPinR2(x, y, pdo.x - 32, pdo.y - 32)) continue;
                s.pSend("<" + pdo.x + "" + pdo.y + "" + parent.toDSChar(m.playermap[pdo.x - 32][pdo.y - 32]) + "" + pdo.colorstring);
            }
        }
    }

    protected static void pdoInit(PlayerDataObject pdo, int shape, DSMapServer m) {
        m.pdos.addElement(pdo);
        DSMapServer.pdoPlaceBroadcast(shape, pdo.colorstring, pdo.x, pdo.y, m);
    }

    protected static void pdoPlaceBroadcast(int shape, String colorstring, char x, char y, DSMapServer m) {
        String tosend = "<" + x + "" + y + "" + parent.toDSChar(shape) + "" + colorstring;
        x = (char)(x - 32);
        y = (char)(y - 32);
        m.playermap[x][y] = shape;
        Enumeration e = m.sockets.elements();
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            if (!DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x, y)) continue;
            c.pSend(tosend);
        }
    }

    protected static void addHole(DSpiresSocket c) {
        if (c.inhand == 0) {
            c.pSend("(* You have nothing to put in the hole.");
            return;
        }
        if (c.weapon != 163) {
            c.pSend("(* You'd put your item in the hole, but you have nothing to use to fill it in.");
            return;
        }
        if (c.inhand == 19) {
            c.pSend("(* The bone doesn't want to go in the hole");
            return;
        }
        if (c.map.holes == null) {
            c.map.holes = new Vector();
        }
        c.map.holes.addElement(c.cx + "" + c.cy + parent.encode(c.inhand));
        c.setHands(0);
        DSMapServer.placeItemAt(0, c.cx - 32, c.cy - 32, c.map);
        c.pSend("(* You bury your item in the hole.");
    }

    protected static void readMapScript(String fn, DSMapServer m) {
        try {
            BufferedReader in = new BufferedReader(new FileReader("../maps/" + fn));
            m.readMapScriptFromReader(in, fn, m);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Exception readMapScriptFromReader(BufferedReader in, String fn, DSMapServer m) {
        if (this.enemybase == null) {
            this.enemybase = new MapEnemyThread(this);
        }
        Vector temp = (Vector)m.enemybase.enemies.clone();
        m.enemybase.enemies.removeAllElements();
        Enumeration e = temp.elements();
        while (e.hasMoreElements()) {
            Enemy c = (Enemy)e.nextElement();
            DSMapServer.pdoPlace(c, 0, "", c.x, c.y, m);
        }
        temp.removeAllElements();
        if (m.bags != null) {
            m.bags.removeAllElements();
        }
        try {
            String line;
            Portal[] oldPortals = null;
            block11: while ((line = in.readLine()) != null && !line.equals("EOF")) {
                int i;
                if (line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    Vector fun;
                    if ((line = line.toLowerCase()).equals("[portals]")) {
                        fun = DSMapServer.grabMapScriptSectionData(in);
                        if (m.portals != null) {
                            oldPortals = m.portals;
                        }
                        m.portals = new Portal[fun.size() + m.maxUploads];
                        for (int i2 = 0; i2 < fun.size(); ++i2) {
                            line = fun.elementAt(i2).toString().trim();
                            StringTokenizer st = new StringTokenizer(line, ",");
                            m.portals[i2] = new Portal();
                            m.portals[i2].orig_x = Integer.parseInt(st.nextToken());
                            m.portals[i2].orig_y = Integer.parseInt(st.nextToken());
                            m.portals[i2].dest_map = m instanceof BasicMap ? m : DSMapServer.parent.maps[Integer.parseInt(st.nextToken()) - 1];
                            try {
                                m.portals[i2].dest_x = Integer.parseInt(st.nextToken());
                                m.portals[i2].dest_y = Integer.parseInt(st.nextToken());
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (oldPortals == null) continue;
                        int pc = fun.size();
                        for (int i3 = 0; i3 < oldPortals.length; ++i3) {
                            if (oldPortals[i3] == null || !(oldPortals[i3].dest_map instanceof BasicMap)) continue;
                            if (pc >= m.portals.length) continue block11;
                            m.portals[pc] = oldPortals[i3];
                            DSMapServer.placeItemAt(151, oldPortals[i3].orig_x, oldPortals[i3].orig_y, m);
                            ++pc;
                        }
                        continue;
                    }
                    if (line.equals("[readables]")) {
                        fun = DSMapServer.grabMapScriptSectionData(in);
                        m.readables = new String[fun.size()];
                        for (int i4 = 0; i4 < fun.size(); ++i4) {
                            m.readables[i4] = fun.elementAt(i4).toString().replace(';', '\n');
                        }
                        continue;
                    }
                    if (line.equals("[holders]")) {
                        fun = DSMapServer.grabMapScriptSectionData(in);
                        m.holders = new int[fun.size() * 4];
                        for (int i5 = 0; i5 < fun.size(); ++i5) {
                            line = fun.elementAt(i5).toString().trim();
                            StringTokenizer st = new StringTokenizer(line, ",");
                            if (st.countTokens() != 3) continue;
                            for (int n = 0; n < 3; ++n) {
                                m.holders[i5 * 4 + n] = (short)Integer.parseInt(st.nextToken());
                            }
                            m.holders[i5 * 4 + 3] = 1;
                            try {
                                if (!(m instanceof BasicMap) || !parent.findIntInArray(m.holders[i5 * 4 + 2], DSMapServer.parent.itemsdisallowed) && DSMapServer.parent.itemdefs[m.holders[i5 * 4 + 2]][0] == 0 && DSMapServer.parent.itemdefs[m.holders[i5 * 4 + 2]][1] == 0) continue;
                                m.holders[i5 * 4 + 2] = 0;
                                m.holders[i5 * 4 + 3] = 0;
                                continue;
                            }
                            catch (Exception n) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (!line.equals("[enemies]") || m instanceof BasicMap) continue;
                    fun = DSMapServer.grabMapScriptSectionData(in);
                    for (int i6 = 0; i6 < fun.size(); ++i6) {
                        line = fun.elementAt(i6).toString().trim();
                        StringTokenizer st = new StringTokenizer(line, ",");
                        m.addEnemy(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), false);
                    }
                    continue;
                }
                if (line.indexOf(61) == -1) continue;
                String var = line.toLowerCase().substring(0, line.indexOf(61));
                String val = line.substring(line.indexOf(61) + 1);
                if (var.equals("start")) {
                    val = val.trim();
                    int i7 = val.indexOf(44);
                    m.xstart = (short)Integer.parseInt(val.substring(0, i7));
                    m.ystart = (short)Integer.parseInt(val.substring(i7 + 1));
                    continue;
                }
                if (var.equals("exits") && !(m instanceof BasicMap)) {
                    val = val.trim();
                    StringTokenizer st = new StringTokenizer(val, ",");
                    for (i = 0; i < 4; ++i) {
                        m.exits[i] = Integer.parseInt(st.nextToken()) - 1;
                    }
                    continue;
                }
                if (var.equals("combatarea")) {
                    val = val.trim();
                    try {
                        StringTokenizer st = new StringTokenizer(val, ",");
                        for (i = 0; i < 5; ++i) {
                            m.attacktiles[i] = Integer.parseInt(st.nextToken());
                        }
                        continue;
                    }
                    catch (Exception st) {
                        continue;
                    }
                }
                if (var.equals("stamval")) {
                    val = val.trim();
                    try {
                        m.stamval = Integer.parseInt(val);
                        if (m.stamval >= -5 && m.stamval <= -1) continue;
                        m.stamval = -1;
                    }
                    catch (Exception ex) {
                        m.stamval = -5;
                    }
                    continue;
                }
                if (var.equals("allowcombat")) {
                    if (val.toLowerCase().equals("true")) {
                        m.allowcombat = true;
                        continue;
                    }
                    m.allowcombat = false;
                    continue;
                }
                if (var.equals("safemap") && !(m instanceof BasicMap)) {
                    if (val.toLowerCase().equals("true")) {
                        m.safemap = true;
                        continue;
                    }
                    m.safemap = false;
                    continue;
                }
                if (var.equals("entrytext")) {
                    if (val.length() <= 0) continue;
                    if (m instanceof BasicMap) {
                        m.entrytext = "[%" + val;
                        continue;
                    }
                    m.entrytext = val;
                    continue;
                }
                if (var.equals("diemap") && !(m instanceof BasicMap)) {
                    val = val.trim();
                    m.diemap = (short)(Integer.parseInt(val) - 1);
                    continue;
                }
                if (var.equals("allowupload") && !(m instanceof BasicMap)) {
                    if (val.toLowerCase().equals("true")) {
                        m.allowupload = true;
                        continue;
                    }
                    m.allowupload = false;
                    continue;
                }
                if (var.equals("maxuploads") && !(m instanceof BasicMap)) {
                    val = val.trim();
                    m.maxUploads = Integer.parseInt(val) - 1;
                    continue;
                }
                if (!var.equals("fountain")) continue;
                val = val.trim();
                int i8 = val.indexOf(44);
                m.fountainx = (short)Integer.parseInt(val.substring(0, i8));
                m.fountainy = (short)Integer.parseInt(val.substring(i8 + 1));
            }
        }
        catch (Exception ex) {
            System.err.println("Error in: " + fn + ".ini");
            ex.printStackTrace();
            return ex;
        }
        return null;
    }

    protected static Vector grabMapScriptSectionData(BufferedReader in) {
        Vector<String> storage = new Vector<String>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    if (!line.equals("[end]")) continue;
                    break;
                }
                if (line.length() == 0) continue;
                storage.addElement(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return storage;
    }

    protected static BagOStuff addBag(int x, int y, int gold, int[] items, DSMapServer m) {
        BagOStuff b;
        if (m.itemmap[x][y] == 201 && m.bags != null) {
            Enumeration e = m.bags.elements();
            while (e.hasMoreElements()) {
                b = (BagOStuff)e.nextElement();
                if (b.x != x || b.y != y) continue;
                b.gold += gold;
                if (b.items.length == 0 && items.length != 0) {
                    DSMapServer.placeItemAt(201, x, y, m);
                }
                int[] newitems = new int[items.length + b.items.length];
                System.arraycopy(b.items, 0, newitems, 0, b.items.length);
                System.arraycopy(items, 0, newitems, b.items.length, items.length);
                return b;
            }
        }
        if (m.bags == null) {
            m.bags = new Vector();
        }
        b = new BagOStuff();
        b.x = x;
        b.y = y;
        b.gold = gold;
        b.items = items;
        m.bags.addElement(b);
        b.below = m.itemmap[x][y];
        b.below = parent.checkForTrans(b.below, x, y, m);
        if (b.items.length == 0) {
            DSMapServer.placeItemAt(6, x, y, m);
        } else {
            DSMapServer.placeItemAt(201, x, y, m);
        }
        return b;
    }

    protected static void destroyMap(DSMapServer m) {
        if (m.owner == null) {
            return;
        }
        for (int i = 0; i < m.parentmap.portals.length; ++i) {
            Portal theportal = m.parentmap.portals[i];
            if (theportal == null || theportal.dest_map != m) continue;
            DSMapServer cfr_ignored_0 = m.parentmap;
            DSMapServer.placeItemAt(0, theportal.orig_x, theportal.orig_y, m.parentmap);
            DSMapServer.broadcast("[&This map has been destroyed.", m);
            Enumeration e = ((Vector)m.sockets.clone()).elements();
            while (e.hasMoreElements()) {
                DSpiresSocket s = (DSpiresSocket)e.nextElement();
                s.changeMap(m.parentmap, 0, 0, 0);
            }
            if (m.parentmap.portals[i] == theportal) {
                m.parentmap.portals[i] = null;
            }
            return;
        }
    }

    public void dualItemBroadcast(int x1, int y1, int i1, int x2, int y2, int i2) {
        Enumeration e = this.sockets.elements();
        String si1 = parent.toDSChar(x1) + "" + parent.toDSChar(y1) + "" + parent.encode(i1);
        String si2 = parent.toDSChar(x2) + "" + parent.toDSChar(y2) + "" + parent.encode(i2);
        while (e.hasMoreElements()) {
            DSpiresSocket c = (DSpiresSocket)e.nextElement();
            boolean inrectshape = DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x1, y1);
            boolean inrectblank = DSMapServer.dsPinR2(c.cx - 32, c.cy - 32, x2, y2);
            if (inrectshape) {
                if (inrectblank) {
                    c.pSend(">" + si1 + si2);
                    continue;
                }
                c.pSend(">" + si1);
                continue;
            }
            if (!inrectblank) continue;
            c.pSend(">" + si2);
        }
    }
}

