/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

public class DragonSpiresConsole
extends Panel {
    Object parent;
    Button btnSound;
    Button btnNew;
    Button btnQuery;
    Checkbox fs;
    Font sf;
    boolean applet = false;
    Choice server;
    Color ff = new Color(179, 207, 235);
    private static final char[][] habl = new char[][]{{'d', 's', '-', 'w', 'e', 's', 't', '.', 'b', 'o', 's', 't', 'e', 'l', 'k', '.', 'c', 'a'}, {'1', '2', '7', '.', '0', '.', '0', '.', '1'}};

    public DragonSpiresConsole(Object p, int smallfont) {
        this.parent = p;
        if (this.parent instanceof DragonSpiresApplet) {
            this.applet = true;
        }
        this.init(smallfont);
    }

    public void init(int smallfont) {
        this.setLayout(null);
        this.sf = new Font("TimesRoman", 1, smallfont);
        this.setBackground(new Color(49, 49, 82));
        this.btnNew = new Button("New Game");
        this.btnNew.move(101, 22);
        this.btnNew.resize(75, 20);
        this.btnNew.setBackground(new Color(49, 49, 82));
        this.btnNew.setForeground(Color.yellow);
        this.btnNew.setFont(this.sf);
        this.add(this.btnNew);
        this.btnQuery = new Button("Query Server");
        this.btnQuery.move(21, 101);
        this.btnQuery.resize(157, 20);
        this.btnQuery.setBackground(new Color(49, 49, 82));
        this.btnQuery.setForeground(Color.yellow);
        this.btnQuery.setFont(this.sf);
        this.add(this.btnQuery);
        if (this.applet) {
            this.btnSound = new Button("Sounds");
            this.btnSound.move(21, 22);
            this.btnSound.resize(75, 20);
            this.btnSound.setBackground(new Color(49, 49, 82));
            this.btnSound.setForeground(Color.yellow);
            this.btnSound.setFont(this.sf);
            this.add(this.btnSound);
            this.btnQuery.move(21, 64);
        } else {
            this.btnNew.move(21, 22);
            this.btnNew.resize(157, 20);
            this.server = new Choice();
            this.server.addItem("US West (main)");
            this.server.addItem("Localhost (test)");
            this.server.resize(100, 20);
            this.server.move(75, 70);
            this.server.setFont(this.sf);
            this.server.setBackground(new Color(49, 49, 82));
            this.server.setForeground(Color.yellow);
            this.add(this.server);
        }
        this.fs = new Checkbox("Fullscreen Mode");
        this.fs.move(50, 43);
        this.fs.resize(125, 20);
        this.fs.setBackground(new Color(49, 49, 82));
        this.fs.setForeground(Color.yellow);
        this.fs.setFont(this.sf);
        this.add(this.fs);
    }

    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.drawRect(0, 0, 198, 129);
        g.drawLine(0, 17, 198, 17);
        g.setFont(this.sf);
        g.setColor(Color.orange);
        g.drawString("DragonSpires Console", 39, 12);
        g.setColor(Color.red);
        if (this.applet) {
            g.drawString("*Warning*", 67, 96);
            g.drawString("Do not close this window until", 20, 108);
            g.drawString("you're ready to quit the game.", 22, 120);
        } else {
            g.drawString("Server:", 25, 86);
        }
    }

    public boolean action(Event e, Object arg) {
        if (e.target == this.btnSound && this.applet) {
            ((DragonSpiresApplet)this.parent).showSound();
            return true;
        }
        if (e.target == this.btnNew) {
            if (this.applet) {
                new DragonSpiresFrame((DragonSpiresApplet)((DragonSpiresApplet)this.parent), (boolean)this.fs.getState()).p.start();
            } else {
                int i = 1;
                if (this.fs.getState()) {
                    i = 0;
                }
                new DragonSpiresFrame(this.server.getSelectedIndex(), i);
            }
            return true;
        }
        if (e.target == this.btnQuery) {
            if (this.applet) {
                new DSQueryFrame(new String(habl[0]));
            } else {
                new DSQueryFrame(new String(habl[this.server.getSelectedIndex()]));
            }
        }
        return true;
    }
}

