/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DSMapCanvas
extends Canvas {
    DragonSpiresPanel parent;
    Image buffImg;
    Image tileImg;
    int xpos;
    int ypos;
    int isrepaint;
    int currx;
    int curry;
    int xs;
    int xe;
    int ys;
    int ye;
    int oe;
    int tilecount;
    int x;
    int y;
    int inshop = -1;
    int drawok = -1;
    int drawTiles = 1;
    int nitems = 0;
    int omdisplaymode = 0;
    int dirtycount = 0;
    int myass;
    int downloadx;
    int downloady;
    int decount = 0;
    final short mwidth = (short)52;
    final short mheight = (short)100;
    private short[][] itemmap;
    private byte[][] tilemap;
    private byte[][] playermap;
    short[][] spellmap;
    int[][] shopitems;
    final byte[][] colorpal = new byte[][]{{0, 0, 55}, {0, 0, -81}, {75, 127, 43}, {83, 83, 119}, {-81, 0, 0}, {-109, 0, -109}, {-53, -109, 79}, {-77, -49, -21}, {55, 55, 83}, {103, 103, -37}, {107, -89, 19}, {99, -109, -97}, {-41, 99, 99}, {-65, 71, -49}, {-25, -37, 79}, {-1, -17, -21}};
    final short[] enecoords = new short[]{1, 1, 23, 17, 25, 1, 23, 17, 49, 1, 24, 16, 74, 1, 23, 16, 98, 1, 23, 17, 122, 1, 23, 17, 146, 1, 24, 16, 171, 1, 23, 16, 195, 1, 25, 17, 221, 1, 25, 17, 247, 1, 24, 17, 272, 1, 25, 17, 298, 1, 23, 17, 322, 1, 23, 17, 346, 1, 23, 17, 370, 1, 23, 17, 1, 19, 41, 35, 43, 19, 44, 44, 88, 19, 47, 36, 136, 19, 41, 45, 178, 19, 37, 36, 216, 19, 40, 31, 257, 19, 44, 37, 302, 19, 41, 32, 344, 19, 30, 56, 1, 65, 30, 57, 32, 65, 32, 56, 65, 65, 32, 57, 98, 65, 28, 54, 127, 65, 28, 54, 156, 65, 32, 56, 189, 65, 33, 56, 223, 65, 23, 51, 247, 65, 26, 53, 274, 65, 23, 50, 298, 65, 28, 53, 327, 76, 25, 52, 353, 76, 25, 53, 1, 130, 28, 53, 30, 130, 24, 54, 55, 130, 47, 49, 103, 130, 50, 52, 154, 130, 37, 50, 192, 130, 38, 52, 231, 130, 46, 52, 278, 130, 48, 52, 327, 130, 38, 52, 1, 185, 36, 52, 38, 185, 38, 56, 77, 185, 42, 55, 120, 185, 38, 56, 159, 185, 44, 55, 204, 185, 40, 56, 245, 185, 43, 52, 289, 185, 39, 56, 329, 185, 44, 52, 1, 242, 43, 55, 45, 242, 39, 56, 85, 242, 42, 55, 128, 242, 42, 55, 171, 242, 42, 54, 214, 242, 40, 55, 255, 242, 43, 55, 299, 242, 43, 55, 343, 242, 40, 58, 1, 301, 39, 57, 41, 301, 39, 57, 81, 301, 40, 58, 122, 301, 40, 58, 163, 301, 39, 57, 203, 301, 40, 57, 244, 301, 41, 58, 286, 301, 34, 50, 321, 301, 32, 53, 354, 301, 35, 52, 1, 360, 40, 51, 42, 360, 29, 51, 72, 360, 31, 55, 104, 360, 32, 56, 137, 360, 33, 52, 171, 360, 44, 55, 216, 360, 38, 56, 255, 360, 38, 57, 294, 360, 38, 55, 333, 360, 38, 55, 1, 418, 37, 55, 39, 418, 46, 55, 86, 418, 39, 55, 126, 418, 42, 56, 169, 418, 42, 56, 212, 418, 41, 56, 254, 418, 41, 56, 296, 418, 42, 56, 339, 418, 42, 56, 1, 475, 40, 56, 42, 475, 40, 56, 83, 475, 28, 56, 112, 475, 24, 56, 137, 475, 25, 56, 163, 475, 28, 56, 192, 475, 28, 56, 221, 475, 26, 56, 248, 475, 26, 56, 275, 475, 27, 55, 303, 475, 42, 55, 346, 475, 37, 55, 1, 532, 40, 55, 42, 532, 40, 55, 83, 532, 40, 54, 124, 532, 38, 55, 163, 532, 41, 55, 205, 532, 41, 55, 247, 532, 30, 54, 278, 532, 29, 55, 308, 532, 29, 55, 338, 532, 29, 54, 368, 532, 28, 53, 1, 588, 25, 54, 27, 588, 25, 54, 53, 588, 26, 53, 80, 588, 29, 59, 110, 588, 31, 58, 142, 588, 27, 59, 170, 588, 31, 58, 202, 588, 31, 59, 234, 588, 33, 58, 268, 588, 28, 59, 297, 588, 33, 58, 331, 588, 31, 59, 363, 588, 34, 59, 1, 648, 31, 59, 33, 648, 33, 59, 67, 648, 35, 59, 103, 648, 33, 59, 137, 648, 35, 59, 173, 648, 33, 59, 207, 648, 29, 52, 237, 648, 28, 55, 266, 648, 29, 52, 296, 648, 28, 55, 325, 648, 30, 53, 356, 648, 29, 55, 1, 708, 30, 53, 32, 708, 29, 55, 62, 708, 37, 58, 100, 708, 34, 58, 135, 708, 37, 58, 173, 708, 34, 58, 208, 708, 36, 57, 245, 708, 39, 57, 285, 708, 36, 57, 322, 708, 39, 57, 362, 708, 31, 55, 1, 767, 28, 55, 30, 767, 31, 55, 62, 767, 28, 55, 91, 767, 30, 56, 122, 767, 29, 56, 152, 767, 30, 56, 183, 767, 29, 56, 213, 767, 28, 60, 242, 767, 28, 59, 271, 767, 28, 59, 300, 767, 28, 59, 329, 767, 28, 59, 358, 767, 28, 59, 1, 823, 28, 59, 30, 823, 28, 59};
    int[] tempmap;
    Graphics buffImgG;
    Graphics tileImgG;
    Graphics g;
    Image[] floors;
    Image[] items;
    ImageProducer[] player;
    ImageProducer itemsrc;
    ImageProducer flrsrc;
    ImageProducer enesrc;
    String[][] colorstrings;
    String buffer_string;
    String[] buffer_string_array;
    final byte[] colorindexes = new byte[]{0, 3, 8, 8, 9, 1, 1, 7, 9, 3, 10, 2, 2, 14, 10, 8, 9, 3, 8, 12, 4, 4, 6, 12, 8, 13, 5, 5, 7, 13, 12, 14, 6, 6, 15, 14, 9, 15, 7, 7, 15, 15};
    Hashtable playercache;
    boolean showstats = false;
    boolean indentline;
    boolean drawcompass = true;
    byte[] itall = null;
    final byte[] ptall = new byte[]{0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    final byte[] ppush = new byte[]{15, 0, 0, 0, 0, 0, 9, 15, 17, 6, 8, 0, 12, 13, 8, 0, 16, 2, 14, 10, 11, 16, 11, 14, 12};
    short[] itemcoords = null;
    short justmoved = (short)3;
    Color[] scolors = new Color[]{Color.black, Color.yellow};

    public DSMapCanvas(DragonSpiresPanel p) {
        this.setBackground(new Color(179, 207, 235));
        this.tilemap = new byte[52][100];
        this.itemmap = new short[52][100];
        this.playermap = new byte[52][100];
        this.spellmap = new short[52][100];
        this.tempmap = new int[132];
        this.parent = p;
        this.floors = new Image[90];
        this.shopitems = new int[7][3];
        this.playercache = new Hashtable();
        this.colorstrings = new String[52][100];
    }

    public void drawShop(Graphics g) {
        g.drawImage(this.parent.wood, 5, 5, this);
        g.setFont(this.parent.fs);
        if (this.inshop == 0) {
            for (int n = 0; n < 2; ++n) {
                g.setColor(this.scolors[n]);
                g.drawLine(7 - n, 23 - n, 254 - n, 23 - n);
                g.drawString(this.buffer_string, 10 - n, 20 - n);
                g.drawString("1. Buy", 10 - n, 38 - n);
                g.drawString("2. Sell", 10 - n, 58 - n);
                g.drawString("Type the number of your selection.", 10 - n, 88 - n);
            }
        } else {
            for (int n = 0; n < 2; ++n) {
                g.setColor(this.scolors[n]);
                g.drawLine(7 - n, 23 - n, 254 - n, 23 - n);
                if (this.inshop == 1) {
                    g.drawString("Item to Buy", 10 - n, 20 - n);
                    g.drawString("Cost", 188 - n, 20 - n);
                } else {
                    g.drawString("Item to Sell", 10 - n, 20 - n);
                    g.drawString("Value", 185 - n, 20 - n);
                }
                g.drawLine(178 - n, 10 - n, 178 - n, 152 - n);
                g.drawLine(222 - n, 10 - n, 222 - n, 152 - n);
            }
            try {
                for (int i = 0; i < 7; ++i) {
                    if (this.shopitems[i][0] <= -1) continue;
                    g.drawImage(this.getItem(this.shopitems[i][0]), 5, 20 + 20 * i, this);
                    g.drawImage(this.getItem(this.shopitems[i][1]), 170, 20 + 20 * i, this);
                    for (int n = 0; n < 2; ++n) {
                        g.setColor(this.scolors[n]);
                        g.drawString(i + 1 + ".", 10 - n, 38 + 20 * i - n);
                        g.drawString("" + this.shopitems[i][2], 182 - n, 43 + 20 * i - n);
                        String tname = DragonSpiresPanel.itemnames[this.shopitems[i][0]];
                        if (tname.startsWith("a")) {
                            tname = tname.substring(tname.indexOf(" ") + 1, tname.length());
                        }
                        g.drawString(tname, 55 - n, 38 + 20 * i - n);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g.setColor(Color.black);
        g.drawString("Press Ctrl-S to close", 79, 158);
        g.setColor(Color.green);
        g.drawString("Press Ctrl-S to close", 78, 157);
    }

    public void drawStats(Graphics g) {
        g.drawImage(this.parent.wood, 5, 5, this);
        g.setFont(this.parent.fs);
        for (int n = 0; n < 2; ++n) {
            g.setColor(this.scolors[n]);
            g.drawLine(7 - n, 23 - n, 254 - n, 23 - n);
            g.drawString("Your Statistics", 10 - n, 20 - n);
            g.drawString("[ " + this.parent.name + " ]", 132 - this.parent.fms.stringWidth("[ " + this.parent.name + " ]") / 2 - n, 38 - n);
            g.drawString("HP:", 50 - n, 58 - n);
            g.drawString("MP:", 48 - n, 78 - n);
            g.drawString("Stamina:", 21 - n, 98 - n);
            g.drawString("Gold:", 41 - n, 118 - n);
            g.drawString("Alignment:", 10 - n, 138 - n);
            g.drawString(this.parent.hp + "/" + this.parent.maxhp, 75 - n, 58 - n);
            g.drawString(this.parent.mp + "/" + this.parent.maxmp, 75 - n, 78 - n);
            g.drawString((int)((float)this.parent.stam / 116.0f * 100.0f) + "%", 75 - n, 98 - n);
            g.drawString(this.parent.gold + "", 75 - n, 118 - n);
            g.drawString(this.parent.aligntexts[this.parent.alignment], 75 - n, 138 - n);
            g.drawString("* Weapon", 145 - n, 58 - n);
            g.drawString("[" + DragonSpiresPanel.itemnames[this.parent.weapon] + "]", 145 - n, 72 - n);
            g.drawString("Damage: " + this.parent.wm + " - " + this.parent.wx, 145 - n, 86 - n);
            g.drawString("* Armor", 145 - n, 110 - n);
            g.drawString("[" + DragonSpiresPanel.itemnames[this.parent.armour] + "]", 145 - n, 124 - n);
            g.drawString("Protect: " + this.parent.am + " - " + this.parent.ax, 145 - n, 138 - n);
        }
    }

    public void paint(Graphics g) {
        try {
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void initMap() {
        this.g.drawString("2 - Clearing buffers...", 5, 55);
        if (this.buffImg == null) {
            this.buffImg = this.createImage(384, 256);
            this.buffImgG = this.buffImg.getGraphics();
            this.tileImg = this.createImage(384, 256);
            this.tileImgG = this.tileImg.getGraphics();
        }
        this.clearPlayerMap();
        for (int i = 0; i < this.tempmap.length; ++i) {
            this.tempmap[i] = -1;
        }
        this.drawTiles = 1;
        this.g.drawString("1 - Assembling map... (this may take a moment)", 5, 75);
        this.isrepaint = 0;
        this.omdisplaymode = 99;
        new Patience(this);
    }

    public void getMapData(String mapname) {
        try {
            int y;
            int x;
            this.parent.append("* Loading map. Please wait. *", 6);
            this.g.drawString("4 - Reading map...", 5, 15);
            InputStream i = this.parent.dsOpenFile(mapname);
            this.g.drawString("3 - Decoding map data...", 5, 35);
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    this.tilemap[x][y] = (byte)this.decode(i.read(), i.read());
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    this.itemmap[x][y] = (short)this.decode(i.read(), i.read());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadMapData(String data) {
        try {
            int datalen = data.length();
            char[] carray = data.toCharArray();
            switch (this.parent.downloading) {
                case 1: {
                    for (int i = 0; i < datalen; i += 2) {
                        this.tilemap[this.downloadx][this.downloady] = (byte)this.decode(carray[i] - 32, carray[i + 1] - 32);
                        ++this.downloady;
                        if (this.downloady != 100) continue;
                        this.downloady = 0;
                        ++this.downloadx;
                        if (this.downloadx != 52) continue;
                        this.parent.downloading = 2;
                        this.downloadx = 0;
                        this.downloady = 0;
                        this.downloadMapData(data.substring(i + 2));
                        return;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < datalen; i += 2) {
                        this.itemmap[this.downloadx][this.downloady] = (short)this.decode(carray[i] - 32, carray[i + 1] - 32);
                        ++this.downloady;
                        if (this.downloady != 100) continue;
                        this.downloady = 0;
                        ++this.downloadx;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int decode(int head, int tack) {
        return head * 95 + tack;
    }

    public void createCacheEntry(String colorstring) {
        try {
            int t;
            char[] cs = colorstring.toCharArray();
            Image[] retimg = null;
            if (cs[3] == ' ') {
                retimg = new Image[16];
                for (int i = 0; i < 16; ++i) {
                    t = i * 4;
                    retimg[i] = this.doImageCrop(this.enesrc, this.enecoords[t], this.enecoords[t + 1], this.enecoords[t + 2], this.enecoords[t + 3]);
                }
            } else if (cs[3] < '&') {
                retimg = new Image[22];
                for (int i = 0; i < 22; ++i) {
                    retimg[i] = this.parent.getRemap(cs, this.player[(cs[3] - 33) * 22 + i]);
                }
            } else {
                t = 64 + (cs[3] - 38) * 32;
                retimg = new Image[12];
                block7: for (int i = 0; i < 12; ++i) {
                    switch (i) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 10: {
                            continue block7;
                        }
                        default: {
                            retimg[i] = this.doImageCrop(this.enesrc, this.enecoords[t], this.enecoords[t + 1], this.enecoords[t + 2], this.enecoords[t + 3]);
                            t += 4;
                        }
                    }
                }
            }
            PICO pico = new PICO(retimg);
            this.playercache.put(colorstring, pico);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeCacheEntry(String colorstring) {
        if (colorstring.equals(this.parent.colorstring)) {
            return;
        }
        this.playercache.remove(colorstring);
        System.gc();
    }

    public void fetchItemImg(int numnum) {
        this.items[--numnum] = this.doImageCrop(this.itemsrc, this.itemcoords[numnum * 4], this.itemcoords[numnum * 4 + 1], this.itemcoords[numnum * 4 + 2], this.itemcoords[numnum * 4 + 3]);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.items[numnum], 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getItem2(int item) {
        if (this.items[item - 1] == null) {
            this.fetchItemImg2(item);
        }
        return this.items[item - 1];
    }

    public void fetchItemImg2(int numnum) {
        this.items[--numnum] = this.doImageCrop(this.itemsrc, this.itemcoords[numnum * 4], this.itemcoords[numnum * 4 + 1], this.itemcoords[numnum * 4 + 2], this.itemcoords[numnum * 4 + 3]);
    }

    public void fetchFloorImg(int numnum) {
        int[] tempo = this.getFloorCoords(numnum);
        this.floors[numnum] = this.doImageCrop(this.flrsrc, tempo[0], tempo[1], 62, 32);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.floors[numnum], 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image doImageCrop(ImageProducer ip, int x, int y, int w, int h) {
        return this.parent.toolkit.createImage(new FilteredImageSource(ip, new CropImageFilter(x, y, w, h)));
    }

    public Image getItem(int item) {
        if (this.items[item - 1] == null) {
            this.fetchItemImg(item);
        }
        return this.items[item - 1];
    }

    public Image getPlayerImage(int x, int y) {
        PICO p = (PICO)this.playercache.get(this.colorstrings[x][y]);
        int sh = this.playermap[x][y] - 1;
        if (p.notloaded[sh]) {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(p.images[sh], 0);
            try {
                mt.waitForID(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            p.notloaded[sh] = false;
        }
        return p.images[sh];
    }

    public int[] getFloorCoords(int floor) {
        int[] retval = new int[2];
        int column = 0;
        int row = 0;
        block0: for (int r = 1; r <= 10; ++r) {
            for (int c = 1; c <= 9; ++c) {
                if (floor != (r - 1) * 9 + (c - 1)) continue;
                column = c;
                row = r;
                continue block0;
            }
        }
        retval[0] = column + (column - 1) * 62;
        retval[1] = row + (row - 1) * 32;
        return retval;
    }

    public void clearPlayerMap() {
        for (int x = 0; x < 52; ++x) {
            for (int y = 0; y < 100; ++y) {
                this.playermap[x][y] = 0;
                this.colorstrings[x][y] = null;
                this.spellmap[x][y] = 0;
            }
        }
    }

    public void drawInv(Graphics g) {
        g.drawImage(this.parent.wood, 5, 5, this);
        g.setFont(this.parent.fs);
        for (int n = 0; n < 2; ++n) {
            g.setColor(this.scolors[n]);
            g.drawLine(7 - n, 23 - n, 254 - n, 23 - n);
            g.drawString("Inventory - Ctrl-V to close. Ctrl-C to swap.", 10 - n, 20 - n);
        }
        int x = -5;
        int y = 23;
        int drawx = 0;
        int drawy = 0;
        int drawi = 0;
        for (int i = 0; i < this.parent.inventory.length; i += 5) {
            for (int n = 0; n < 5 && i + n < this.parent.inventory.length; ++n) {
                if (i + n == this.parent.invsel) {
                    drawx = x;
                    drawy = y;
                    drawi = i + n;
                }
                if (this.parent.inventory[i + n] > 0) {
                    g.drawImage(this.getItem2(this.parent.inventory[i + n]), x, y - this.itall[this.parent.inventory[i + n]], this);
                }
                y += 25;
            }
            x += 35;
            y = 23;
        }
        g.setColor(Color.green);
        g.drawOval(drawx + 16, drawy, 28, 28);
        if (this.parent.inventory[drawi] != 0) {
            String thestring = "";
            thestring = this.parent.inventory[drawi] > this.nitems ? DragonSpiresPanel.animnames[(this.parent.inventory[drawi] + 1 - this.nitems - 2) / 8] : DragonSpiresPanel.itemnames[this.parent.inventory[drawi]];
            g.setFont(this.parent.fs);
            g.setColor(this.parent.dsbg2);
            g.fillRect(drawx + 34, drawy + 20, this.parent.fms.stringWidth(thestring) + 10, 15);
            g.setColor(Color.black);
            g.drawRect(drawx + 34, drawy + 20, this.parent.fms.stringWidth(thestring) + 10, 15);
            g.setColor(this.parent.dsbg);
            g.drawString(thestring, drawx + 39, drawy + 32);
        }
    }

    public void placePlayer(String incoming) {
        int y;
        int x;
        char[] ichar = incoming.toCharArray();
        if (ichar.length == 4) {
            ichar[1] = (char)(ichar[1] - 32);
            ichar[2] = (char)(ichar[2] - 32);
            this.blankOutPlayer(ichar[1], ichar[2]);
            this.repaint();
            return;
        }
        String tcs = ichar[4] + "" + ichar[5] + "" + ichar[6] + "" + ichar[7];
        if (ichar[3] != ' ') {
            x = ichar[1] - 32;
            y = ichar[2] - 32;
            if (y >= 100) {
                y = 99;
            }
            if (y < 0) {
                y = 0;
            }
            if (x >= 52) {
                x = 51;
            }
            if (x < 0) {
                x = 0;
            }
        } else {
            this.blankOutPlayer2(ichar, tcs);
            this.repaint();
            return;
        }
        this.playermap[x][y] = (byte)(ichar[3] - 32);
        this.colorstrings[x][y] = tcs;
        if (ichar.length == 11) {
            ichar[8] = (char)(ichar[8] - 32);
            ichar[9] = (char)(ichar[9] - 32);
            this.blankOutPlayer(ichar[8], ichar[9]);
            this.drawDoubleDirty(this.xpos, this.ypos, x, y, ichar[8], ichar[9]);
        } else {
            if (!this.playercache.containsKey(tcs)) {
                this.createCacheEntry(tcs);
            }
            this.drawDirty(x, y);
        }
    }

    public void blankOutPlayer(char x, char y) {
        this.playermap[x][y] = 0;
        this.colorstrings[x][y] = null;
    }

    public void blankOutPlayer2(char[] ichar, String tcs) {
        ichar[1] = (char)(ichar[1] - 32);
        ichar[2] = (char)(ichar[2] - 32);
        this.blankOutPlayer(ichar[1], ichar[2]);
        this.removeCacheEntry(tcs);
        this.repaint();
    }

    public void placeItem(String incoming) {
        int x2 = 0;
        int y2 = 0;
        if (incoming.length() == 9) {
            x2 = incoming.charAt(5) - 32;
            y2 = incoming.charAt(6) - 32;
            if (x2 > 0 && x2 < 52 && y2 > 0 && y2 < 100) {
                this.itemmap[x2][y2] = (short)this.decode(incoming.charAt(7) - 32, incoming.charAt(8) - 32);
            }
        }
        int x1 = incoming.charAt(1) - 32;
        int y1 = incoming.charAt(2) - 32;
        if (x1 > 0 && x1 < 52 && y1 > 0 && y1 < 100) {
            this.itemmap[x1][y1] = (short)this.decode(incoming.charAt(3) - 32, incoming.charAt(4) - 32);
            if (this.parent.dsPinR(x1, y1)) {
                if (incoming.length() == 9) {
                    this.drawDoubleDirty(this.xpos, this.ypos, x1, y1, x2, y2);
                } else {
                    this.drawDirty(x1, y1);
                }
            }
        }
    }

    public void cacheCleanup() {
        int i;
        int i2;
        int xs = this.xpos - 3;
        int xe = this.xpos + 3;
        int ys = this.ypos - 8;
        int ye = this.ypos + 8;
        Vector<String> s2s = new Vector<String>();
        int[] items2save = new int[this.nitems];
        int[] floors2save = new int[this.floors.length];
        int item = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            switch (i2) {
                case 0: {
                    item = this.parent.weapon;
                    break;
                }
                case 1: {
                    item = this.parent.armour;
                    break;
                }
                case 2: {
                    item = this.parent.afeet;
                    break;
                }
                case 3: {
                    item = this.parent.ahands;
                }
            }
            if (item <= 0 || item >= items2save.length) continue;
            items2save[item - 1] = 1;
        }
        if (this.parent.map.omdisplaymode == 2) {
            for (i2 = 0; i2 < this.parent.inventory.length; ++i2) {
                if (this.parent.inventory[i2] <= 0 || this.parent.inventory[i2] >= items2save.length) continue;
                items2save[this.parent.inventory[i2] - 1] = 1;
            }
        }
        for (int y = ys; y <= ye; ++y) {
            for (int x = xs; x <= xe; ++x) {
                try {
                    short moreass;
                    if (this.colorstrings[x][y] != null) {
                        s2s.addElement(this.parent.map.colorstrings[x][y]);
                    }
                    if ((moreass = this.itemmap[x][y]) > 0 && moreass < this.nitems) {
                        items2save[moreass - 1] = 1;
                    }
                    floors2save[this.tilemap[x][y]] = 1;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Enumeration e = this.parent.map.playercache.keys();
        while (e.hasMoreElements()) {
            String tcs = e.nextElement().toString();
            boolean delit = true;
            for (int i3 = 0; i3 < s2s.size(); ++i3) {
                if (!s2s.elementAt(i3).toString().equals(tcs)) continue;
                delit = false;
                break;
            }
            if (!delit) continue;
            this.removeCacheEntry(tcs);
        }
        for (i = 0; i < items2save.length; ++i) {
            if (items2save[i] != 0) continue;
            this.items[i] = null;
        }
        for (i = 0; i < floors2save.length; ++i) {
            if (floors2save[i] != 0) continue;
            this.floors[i] = null;
        }
        this.parent.sthread.cachecheck = 0;
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (this.parent.keyok) {
            this.parent.mapMouseDown(x, y);
        }
        return false;
    }

    public boolean mouseMove(Event e, int x, int y) {
        if (y < 103) {
            if (x < 192) {
                if (this.parent.dirpoint != 3) {
                    int t = this.parent.dirpoint;
                    this.parent.repaintDIRPoint(t);
                    this.parent.dirpoint = 3;
                    this.parent.repaintDIRPoint(3);
                }
            } else if (this.parent.dirpoint != 4) {
                int t = this.parent.dirpoint;
                this.parent.repaintDIRPoint(t);
                this.parent.dirpoint = 4;
                this.parent.repaintDIRPoint(4);
            }
        } else if (y > 153) {
            if (x < 192) {
                if (this.parent.dirpoint != 1) {
                    int t = this.parent.dirpoint;
                    this.parent.repaintDIRPoint(t);
                    this.parent.dirpoint = 1;
                    this.parent.repaintDIRPoint(1);
                }
            } else if (this.parent.dirpoint != 2) {
                int t = this.parent.dirpoint;
                this.parent.repaintDIRPoint(t);
                this.parent.dirpoint = 2;
                this.parent.repaintDIRPoint(2);
            }
        } else if (x < 192) {
            if (this.parent.dirpoint != 5) {
                int t = this.parent.dirpoint;
                this.parent.repaintDIRPoint(t);
                this.parent.dirpoint = 5;
                this.parent.repaintDIRPoint(5);
            }
        } else if (this.parent.dirpoint != 6) {
            int t = this.parent.dirpoint;
            this.parent.repaintDIRPoint(t);
            this.parent.dirpoint = 6;
            this.parent.repaintDIRPoint(6);
        }
        return true;
    }

    public boolean mouseExit(Event e, int x, int y) {
        if (this.parent.dirpoint != 0) {
            int t = this.parent.dirpoint;
            this.parent.dirpoint = 0;
            this.parent.repaintDIRPoint(t);
        }
        return true;
    }

    public void requestOMDisplay(int mode) {
        switch (this.omdisplaymode) {
            case 3: {
                this.parent.clearShop(mode);
                break;
            }
            case 4: {
                this.buffer_string = null;
                this.buffer_string_array = null;
                break;
            }
            case 1: {
                if (mode != 1) break;
                mode = 0;
            }
        }
        this.omdisplaymode = mode == -1 ? 0 : mode;
        switch (mode) {
            case 3: 
            case 4: {
                break;
            }
            default: {
                this.drawOMDisplay(this.getGraphics(), true);
            }
        }
    }

    public void drawOMDisplay(Graphics g, boolean repaint) {
        if (repaint) {
            this.repaint();
        }
        switch (this.omdisplaymode) {
            case 0: {
                this.repaint();
                break;
            }
            case 1: {
                this.drawStats(g);
                break;
            }
            case 2: {
                this.drawInv(g);
                break;
            }
            case 3: {
                this.drawShop(g);
                break;
            }
            case 4: {
                this.drawInteraction(g);
            }
        }
    }

    public void drawInteraction(Graphics g) {
        g.drawImage(this.parent.wood, 5, 5, this);
        g.setFont(this.parent.fs);
        for (int n = 0; n < 2; ++n) {
            g.setColor(this.scolors[n]);
            g.drawLine(7 - n, 23 - n, 254 - n, 23 - n);
            g.drawString(this.buffer_string, 10 - n, 20 - n);
            int i = 0;
            int y = 35;
            while (this.buffer_string_array[i] != null) {
                g.drawString(this.buffer_string_array[i], 10 - n, y - n);
                ++i;
                y += 11;
            }
        }
        g.setColor(Color.black);
        g.drawString("Press Ctrl-L to close", 79, 158);
        g.setColor(Color.green);
        g.drawString("Press Ctrl-L to close", 78, 157);
    }

    public void repaint() {
        if (this.drawok == 1 && this.isrepaint == 0) {
            this.isrepaint = 1;
            this.oe = this.ypos % 2;
            this.xs = this.xpos - 3;
            this.ys = this.ypos - 8;
            this.xe = this.xpos + 3;
            this.ye = this.ypos + 8;
            if (this.drawTiles == 1) {
                this.drawTileGraphics();
            }
            this.buffImgG.drawImage(this.tileImg, 0, 0, this);
            this.curry = -16;
            this.indentline = false;
            this.ye += 2;
            if (this.oe == 0) {
                this.drawIPEven();
            } else {
                this.drawIPOdd();
            }
            if (this.omdisplaymode != 0) {
                this.drawOMDisplay(this.buffImgG, false);
            }
            if (this.drawcompass) {
                this.buffImgG.drawImage(this.parent.compass, 333, 1, this);
            }
            this.g.drawImage(this.buffImg, 0, 0, this);
            this.isrepaint = 0;
        }
    }

    public void drawDirty(int x, int y) {
        if (this.justmoved != 0) {
            this.justmoved = (short)(this.justmoved - 1);
            this.repaint();
            return;
        }
        new dirtyThread(x, y, this);
    }

    public void drawDoubleDirty(int xpos, int ypos, int x, int y, int x2, int y2) {
        if (this.justmoved != 0) {
            this.justmoved = (short)(this.justmoved - 1);
            this.repaint();
            return;
        }
        try {
            if (this.omdisplaymode != 0 || ++this.dirtycount == 3) {
                this.dirtycount = 0;
                this.repaint();
                return;
            }
            if (this.drawok == 1) {
                int xx = 160 - (xpos - x) * 64;
                if (ypos % 2 != y % 2) {
                    xx = this.oe == 0 ? (xx -= 32) : (xx += 32);
                }
                int yy = 48 - (ypos - y) * 16;
                int xx2 = 160 - (xpos - x2) * 64;
                if (ypos % 2 != y2 % 2) {
                    xx2 = this.oe == 0 ? (xx2 -= 32) : (xx2 += 32);
                }
                int yy2 = 48 - (ypos - y2) * 16;
                Image i = this.getDirtyImage(x, y);
                Image i2 = this.getDirtyImage(x2, y2);
                this.g.drawImage(i2, xx2, yy2, this);
                this.g.drawImage(i, xx, yy, this);
                if (this.drawcompass) {
                    this.g.drawImage(this.parent.compass, 333, 1, this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getDirtyImage(int x, int y) {
        Image i = this.createImage(62, 96);
        Graphics g = i.getGraphics();
        int dys = y - 5;
        int dye = y + 2;
        int curry = -16;
        boolean indentline = false;
        if (y % 2 == 0) {
            int currx;
            int dxs = x;
            int dxe = x + 2;
            for (y = dys; y <= dye; ++y) {
                currx = indentline ? 1 : -31;
                for (x = dxs; x < dxe; ++x) {
                    this.drawTileSimple2(x, y, currx, curry, g);
                    currx += 64;
                }
                if (y % 2 != 0) {
                    this.drawTileSimple2(x, y, currx, curry, g);
                }
                curry += 16;
                indentline = !indentline;
            }
            dye += 4;
            indentline = false;
            curry = -16;
            for (y = dys; y <= dye; ++y) {
                currx = indentline ? 1 : -31;
                for (x = dxs; x < dxe; ++x) {
                    this.drawIPSimple2(x, y, currx, curry, g);
                    currx += 64;
                }
                if (y % 2 != 0) {
                    this.drawIPSimple2(x, y, currx, curry, g);
                }
                curry += 16;
                indentline = !indentline;
            }
        } else {
            int currx;
            int dxs = x - 1;
            int dxe = x + 1;
            for (y = dys; y <= dye; ++y) {
                currx = indentline ? 1 : -31;
                x = dxs;
                if (y % 2 != 0) {
                    ++x;
                }
                while (x <= dxe) {
                    this.drawTileSimple2(x, y, currx, curry, g);
                    currx += 64;
                    ++x;
                }
                curry += 16;
                indentline = !indentline;
            }
            dye += 4;
            indentline = false;
            curry = -16;
            for (y = dys; y <= dye; ++y) {
                currx = indentline ? 1 : -31;
                x = dxs;
                if (y % 2 != 0) {
                    ++x;
                }
                while (x <= dxe) {
                    this.drawIPSimple2(x, y, currx, curry, g);
                    currx += 64;
                    ++x;
                }
                curry += 16;
                indentline = !indentline;
            }
        }
        return i;
    }

    public void drawIPEven() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            if (this.y % 2 != 0) {
                ++this.x;
            }
            while (this.x <= this.xe) {
                this.drawIPSimple();
                this.currx += 64;
                ++this.x;
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawIPOdd() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            while (this.x < this.xe) {
                this.drawIPSimple();
                this.currx += 64;
                ++this.x;
            }
            if (this.y % 2 != 0) {
                this.drawIPSimple();
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawIPSimple() {
        try {
            this.myass = this.itemmap[this.x][this.y];
            if (this.myass != 0) {
                this.buffImgG.drawImage(this.getItem(this.myass), this.currx, this.curry - this.itall[this.myass], this);
            }
            if (this.playermap[this.x][this.y] != 0) {
                int t = this.colorstrings[this.x][this.y].charAt(3) - 32;
                this.buffImgG.drawImage(this.getPlayerImage(this.x, this.y), this.currx + this.ppush[t], this.curry - this.ptall[t], this);
            }
            this.myass = this.spellmap[this.x][this.y];
            if (this.myass != 0) {
                this.buffImgG.drawImage(this.getItem(this.myass), this.currx, this.curry - this.itall[this.myass], this);
            }
        }
        catch (Exception e) {
            this.IPExceptionHandle(this.x, this.y, this.currx, this.curry, this.buffImgG, e);
        }
    }

    public void drawTileGraphics() {
        this.tilecount = 0;
        this.curry = -16;
        this.indentline = false;
        if (this.oe == 0) {
            this.drawTileEven();
        } else {
            this.drawTileOdd();
        }
        this.drawTiles = 0;
    }

    public void drawTileEven() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            if (this.y % 2 != 0) {
                ++this.x;
            }
            while (this.x <= this.xe) {
                this.drawTileSimple();
                this.currx += 64;
                ++this.x;
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawTileOdd() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            while (this.x < this.xe) {
                this.drawTileSimple();
                this.currx += 64;
                ++this.x;
            }
            if (this.y % 2 != 0) {
                this.drawTileSimple();
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawTileSimple() {
        try {
            this.myass = this.tilemap[this.x][this.y];
            if (this.myass != this.tempmap[this.tilecount]) {
                while (this.floors[this.myass] == null) {
                    this.fetchFloorImg(this.tilemap[this.x][this.y]);
                }
                this.tileImgG.drawImage(this.floors[this.myass], this.currx, this.curry, this);
                this.tempmap[this.tilecount] = this.myass;
            }
        }
        catch (Exception e) {
            this.tempmap[this.tilecount] = -1;
        }
        ++this.tilecount;
    }

    public void drawTileSimple2(int x, int y, int currx, int curry, Graphics g) {
        try {
            this.myass = this.tilemap[x][y];
            if (this.floors[this.myass] == null) {
                this.fetchFloorImg(this.myass);
            }
            g.drawImage(this.floors[this.myass], currx, curry, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawIPSimple2(int x, int y, int currx, int curry, Graphics g) {
        try {
            short myass = this.itemmap[x][y];
            if (myass != 0) {
                g.drawImage(this.getItem(myass), currx, curry - this.itall[myass], this);
            }
            if (this.playermap[x][y] != 0) {
                int t = this.colorstrings[x][y].charAt(3) - 32;
                g.drawImage(((PICO)this.playercache.get((Object)this.colorstrings[x][y])).images[this.playermap[x][y] - 1], currx + this.ppush[t], curry - this.ptall[t], this);
            }
            if ((myass = this.spellmap[x][y]) != 0) {
                g.drawImage(this.getItem(myass), currx, curry - this.itall[myass], this);
            }
        }
        catch (Exception e) {
            this.IPExceptionHandle(x, y, currx, curry, g, e);
        }
    }

    public void IPExceptionHandle(int x, int y, int currx, int curry, Graphics g, Exception e) {
        if (e instanceof NullPointerException) {
            String cs = this.colorstrings[x][y];
            try {
                if (((PICO)this.playercache.get((Object)cs)).images[this.playermap[x][y] - 1] == null && cs.charAt(3) > ' ' && cs.charAt(3) < '&') {
                    this.removeCacheEntry(cs);
                    this.createCacheEntry(cs);
                    this.drawIPSimple2(x, y, currx, curry, g);
                }
            }
            catch (NullPointerException exxx) {
                this.createCacheEntry(cs);
                return;
            }
        }
        g.drawImage(this.parent.end, currx, curry, this);
    }
}

