/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Vector;

public class DSEdit
extends Panel {
    Object parent;
    DSEMapCanvas map;
    Font f;
    FontMetrics fm;
    private DataInputStream i;
    private PrintStream o;
    private Socket s;
    Thread listen;
    Vector ignores;
    Image[] hps;
    Image marbled;
    Image preview;
    Image end;
    Image typebuffimg;
    Image compass;
    Graphics ttg;
    boolean keyok;
    boolean amapplet;
    boolean saved = true;
    Color dsbg;
    Color dstext;
    Toolkit toolkit;
    private String[] TextArray;
    String line1 = "";
    String line2 = "";
    String path;
    String colorstring;
    String connstat;
    String name;
    int[] inventory;
    int keyhold;
    int t;
    int ledin = -3;
    int scrollpos = 6;
    Frame fr;
    boolean dialog = false;
    int dialognum = -1;
    String dialogdata;
    String dialogtext;

    public static void main(String[] args) {
        Frame frame = new Frame("LOADING . . .");
        DSEdit p = new DSEdit(frame);
        frame.add("Center", p);
        frame.resize(586, 441);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.move(d.width / 2 - 293, d.height / 2 - 220);
        frame.setIconImage(p.toolkit.getImage("edit1.gif"));
        frame.show();
        p.start();
        frame.setTitle("DragonSpires Map Editor");
    }

    public DSEdit(Frame frt) {
        this.fr = frt;
        System.out.println("\n\nIt's okay to hide me! =)");
        this.setLayout(null);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.keyok = false;
        this.connstat = "";
        this.line2 = "";
        this.line1 = "";
        this.dsbg = new Color(179, 207, 235);
        this.dstext = new Color(0, 0, 55);
        this.TextArray = new String[30];
        for (int i = 0; i < this.TextArray.length; ++i) {
            this.TextArray[i] = "";
        }
        this.end = this.toolkit.getImage("end.gif");
        this.marbled = this.toolkit.getImage("marbled.gif");
        this.f = new Font("TimesRoman", 1, 12);
        this.fm = this.getFontMetrics(this.f);
        this.map = new DSEMapCanvas(this);
        this.map.move(183, 11);
        this.map.resize(385, 256);
        this.map.hide();
        this.add(this.map);
    }

    public void start() {
        this.doTracker();
        this.typebuffimg = this.createImage(406, 26);
        this.ttg = this.typebuffimg.getGraphics();
        this.ledin = 1;
        this.setupNewMap("lev01.dsmap");
        this.map.show();
        this.repaint();
        this.resumeMapDraw();
        this.append("Welcome to the DragonSpires Editor. Press Z for help.");
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.map.drawok >= 0) {
            g.drawImage(this.marbled, 0, 0, this);
            g.setColor(this.dstext);
            for (int spm = 0; spm < 7; ++spm) {
                g.drawString(this.TextArray[this.scrollpos - spm], 163, 279 + 12 * (spm + 1));
            }
            this.drawTypeText();
        }
    }

    private void updatePos(int x, int y) {
        this.map.xpos = x;
        this.map.ypos = y;
        this.map.drawTiles = 1;
        this.dataString();
        this.drawTypeText();
        this.map.repaint();
    }

    public void incomingText(String incoming) {
        for (int i = 0; i < this.ignores.size(); ++i) {
            if (!incoming.toLowerCase().startsWith(this.ignores.elementAt(i).toString())) continue;
            return;
        }
        this.append(incoming);
    }

    public void haltMapDraw() {
        this.keyok = false;
        this.map.drawok = 0;
        this.map.repaint();
    }

    public void resumeMapDraw() {
        this.keyok = true;
        this.map.drawok = 1;
        this.map.repaint();
    }

    public void setupNewMap(String name) {
        File testfile = new File(name);
        if (testfile.exists()) {
            if (!this.saved) {
                this.initDialog(1, "This map isn't saved. Save it? (Y/N)", name);
                return;
            }
            this.map.getMapData(name);
            this.map.initMap();
            this.map.repaint();
            this.saved = true;
        } else {
            this.initDialog(3, name + " doesn't exist. Would you like to create it? (Y/N)", name);
        }
    }

    public boolean mouseDown(Event e, int x, int y) {
        return false;
    }

    public boolean keyUp(Event e, int key) {
        this.keyhold = 0;
        return true;
    }

    public boolean keyDown(Event e, int key) {
        if (this.keyok) {
            if (this.dialog) {
                this.dialogInput(key);
                return true;
            }
            switch (key) {
                case 43: {
                    if (this.map.currseltype == 1) {
                        if (++this.map.curritemsel > this.map.nitems) {
                            this.map.curritemsel = this.map.nitems;
                        }
                        this.map.itemmap[this.map.xpos][this.map.ypos] = this.map.curritemsel;
                    } else if (this.map.currseltype == 2) {
                        this.map.drawTiles = 1;
                        if (++this.map.currfloorsel > this.map.floors.length) {
                            this.map.currfloorsel = this.map.floors.length;
                        }
                        this.map.tilemap[this.map.xpos][this.map.ypos] = this.map.currfloorsel;
                    }
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 45: {
                    if (this.map.currseltype == 1) {
                        if (--this.map.curritemsel < 0) {
                            this.map.curritemsel = 0;
                        }
                        this.map.itemmap[this.map.xpos][this.map.ypos] = this.map.curritemsel;
                    } else if (this.map.currseltype == 2) {
                        this.map.drawTiles = 1;
                        if (--this.map.currfloorsel < 0) {
                            this.map.curritemsel = 0;
                        }
                        this.map.tilemap[this.map.xpos][this.map.ypos] = this.map.currfloorsel;
                    }
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 46: {
                    if (this.map.currseltype == 1) {
                        if ((this.map.curritemsel += 10) > this.map.nitems) {
                            this.map.curritemsel = this.map.nitems;
                        }
                        this.map.itemmap[this.map.xpos][this.map.ypos] = this.map.curritemsel;
                    } else if (this.map.currseltype == 2) {
                        this.map.drawTiles = 1;
                        if ((this.map.currfloorsel += 10) > this.map.floors.length) {
                            this.map.currfloorsel = this.map.floors.length;
                        }
                        this.map.tilemap[this.map.xpos][this.map.ypos] = this.map.currfloorsel;
                    }
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 44: {
                    if (this.map.currseltype == 1) {
                        if ((this.map.curritemsel -= 10) < 0) {
                            this.map.curritemsel = 0;
                        }
                        this.map.itemmap[this.map.xpos][this.map.ypos] = this.map.curritemsel;
                    } else if (this.map.currseltype == 2) {
                        this.map.drawTiles = 1;
                        if ((this.map.currfloorsel -= 10) < 0) {
                            this.map.curritemsel = 0;
                        }
                        this.map.tilemap[this.map.xpos][this.map.ypos] = this.map.currfloorsel;
                    }
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 49: {
                    this.map.currseltype = 1;
                    this.map.tilemap[this.map.xpos][this.map.ypos] = this.t;
                    this.t = this.map.itemmap[this.map.xpos][this.map.ypos];
                    this.map.itemmap[this.map.xpos][this.map.ypos] = this.map.curritemsel;
                    this.map.drawTiles = 1;
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 50: {
                    this.map.currseltype = 2;
                    this.map.itemmap[this.map.xpos][this.map.ypos] = this.t;
                    this.t = this.map.tilemap[this.map.xpos][this.map.ypos];
                    this.map.tilemap[this.map.xpos][this.map.ypos] = this.map.currfloorsel;
                    this.map.drawTiles = 1;
                    this.dataString();
                    this.drawTypeText();
                    this.map.repaint();
                    return true;
                }
                case 67: 
                case 99: {
                    if (this.map.currseltype == 1) {
                        for (int x = 0; x < this.map.mwidth; ++x) {
                            for (int y = 0; y < this.map.mheight; ++y) {
                                this.map.itemmap[x][y] = this.map.curritemsel;
                            }
                        }
                    } else if (this.map.currseltype == 2) {
                        for (int x = 0; x < this.map.mwidth; ++x) {
                            for (int y = 0; y < this.map.mheight; ++y) {
                                this.map.tilemap[x][y] = this.map.currfloorsel;
                            }
                        }
                    }
                    return true;
                }
                case 83: 
                case 115: {
                    this.map.saveMap();
                    return true;
                }
                case 79: 
                case 111: {
                    this.OBclear();
                    this.initDialog(2, "Type the map filename you want to open below then press Enter.", "");
                    return true;
                }
                case 90: 
                case 122: {
                    this.append("Press 1 to select items, 2 to select floors. +/- to select.");
                    this.append("Press Enter to place. Press Space to toggle drag.");
                    this.append("Press S to save map. Press O to open a map.");
                    this.append("Press ESC to exit.");
                    return true;
                }
                case 10: {
                    this.enterPress();
                    return true;
                }
                case 32: {
                    boolean bl = this.map.drag = !this.map.drag;
                    if (!this.map.drag) {
                        this.enterPress();
                    }
                    return true;
                }
                case 27: {
                    if (!this.saved) {
                        this.initDialog(0, "This map isn't saved. Save it? (Y/N/C)", "");
                        return true;
                    }
                    this.fr.dispose();
                    System.exit(0);
                    return true;
                }
                case 1004: {
                    if (this.upPress(e)) {
                        return true;
                    }
                }
                case 1002: {
                    if (this.map.drag) {
                        this.enterPress();
                    }
                    this.goThatWay(9);
                    return true;
                }
                case 1005: {
                    if (this.downPress(e)) {
                        return true;
                    }
                }
                case 1001: {
                    if (this.map.drag) {
                        this.enterPress();
                    }
                    this.goThatWay(1);
                    return true;
                }
                case 1006: {
                    if (this.leftPress(e)) {
                        return true;
                    }
                }
                case 1000: {
                    if (this.map.drag) {
                        this.enterPress();
                    }
                    this.goThatWay(7);
                    return true;
                }
                case 1007: {
                    if (this.rightPress(e)) {
                        return true;
                    }
                }
                case 1003: {
                    if (this.map.drag) {
                        this.enterPress();
                    }
                    this.goThatWay(3);
                    return true;
                }
                case 9: {
                    return true;
                }
            }
            if (e.controlDown()) {
                this.controlKeyDown(key);
                return true;
            }
        }
        return false;
    }

    public void enterPress() {
        if (this.saved) {
            this.saved = false;
        }
        if (this.map.currseltype == 1) {
            this.t = this.map.curritemsel;
        } else if (this.map.currseltype == 2) {
            this.t = this.map.currfloorsel;
        }
    }

    private void controlKeyDown(int key) {
    }

    public boolean action(Event e, Object arg) {
        return false;
    }

    public int nextx(int x, int y, int dir) {
        int nx = x;
        switch (dir) {
            case 3: 
            case 9: {
                if (y % 2 != 0) break;
                ++nx;
                break;
            }
            case 1: 
            case 7: {
                if (y % 2 != 1) break;
                --nx;
            }
        }
        if (nx < 0) {
            nx = x;
        } else if (nx >= this.map.mwidth) {
            nx = x;
        }
        return nx;
    }

    public int nexty(int x, int y, int dir) {
        int ny = y;
        switch (dir) {
            case 7: 
            case 9: {
                --ny;
                break;
            }
            case 1: 
            case 3: {
                ++ny;
            }
        }
        if (ny < 0) {
            ny = y;
        } else if (ny >= this.map.mheight) {
            ny = y;
        }
        return ny;
    }

    public void doTracker() {
        String[] ttt = new String[]{"floors", "items"};
        String[] tttn = new String[]{"floor.gif", "item256.gif"};
        Image[] ttti = new Image[tttn.length];
        MediaTracker tracker = new MediaTracker(this);
        for (int i = 0; i < tttn.length; ++i) {
            this.connstat = "Now loading " + ttt[i] + "...";
            this.repaint(0, 370, this.size().width, this.size().height);
            ttti[i] = this.toolkit.getImage(tttn[i]);
            tracker.addImage(ttti[i], i);
            try {
                tracker.waitForID(i);
                while (!tracker.checkID(i)) {
                }
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.connstat = "Processing...";
        this.repaint(0, 370, this.size().width, this.size().height);
        this.map.flrsrc = ttti[0].getSource();
        ItemImgSep iis = new ItemImgSep(this.map, null, this.toolkit);
        iis.doEditor(this.map);
        this.map.itemsrc = ttti[1].getSource();
    }

    public void append(String text) {
        int i;
        String templine = "";
        String tempword = "";
        char[] charys = text.toCharArray();
        String[] words = new String[]{};
        for (i = 0; i < charys.length; ++i) {
            if (charys[i] == ' ' || i == charys.length - 1) {
                String[] tempwords = new String[words.length + 1];
                for (int n = 0; n < words.length; ++n) {
                    tempwords[n] = words[n];
                }
                tempwords[words.length] = tempword + charys[i];
                words = tempwords;
                tempword = "";
                continue;
            }
            tempword = tempword + charys[i];
        }
        for (i = 0; i < words.length; ++i) {
            tempword = words[i];
            if (this.fm.stringWidth(templine + tempword) < 406) {
                templine = templine + tempword;
                continue;
            }
            this.addLine(templine);
            templine = tempword;
            while (this.fm.stringWidth(templine) > 406) {
                String[] tempstuff = this.trimLongLine(templine);
                this.addLine(tempstuff[0]);
                templine = tempstuff[1];
            }
        }
        this.addLine(templine);
        this.repaint(162, 279, 406, 90);
    }

    public String[] trimLongLine(String text) {
        String[] retval = new String[]{"", ""};
        char[] charys = text.toCharArray();
        for (int i = 0; i < charys.length; ++i) {
            if (this.fm.stringWidth(retval[0] + charys[i]) > 406) {
                for (int n = i; n < charys.length; ++n) {
                    retval[1] = retval[1] + charys[i];
                }
                return retval;
            }
            retval[0] = retval[0] + charys[i];
        }
        return null;
    }

    public void addLine(String text) {
        text = text.replace('|', ' ');
        for (int i = this.TextArray.length - 1; i > 0; --i) {
            this.TextArray[i] = this.TextArray[i - 1];
        }
        this.TextArray[0] = text;
        if (this.scrollpos > 6) {
            ++this.scrollpos;
            if (this.scrollpos > this.TextArray.length - 1) {
                this.scrollpos = this.TextArray.length - 1;
            }
        }
    }

    public void scrollUp() {
        if (this.scrollpos < this.TextArray.length - 1) {
            ++this.scrollpos;
            this.repaint(162, 279, 406, 90);
        }
    }

    public void scrollDown() {
        if (this.scrollpos > 6) {
            --this.scrollpos;
            this.repaint(162, 279, 406, 90);
        }
    }

    public void append(char c) {
        if (this.line1 != "" && this.fm.stringWidth(this.line1 + c + "|") <= 406 && this.line2.equals("")) {
            this.line1 = this.line1.substring(0, this.line1.length() - 1) + c + "|";
        } else if (this.fm.stringWidth(this.line1 + c + "|") <= 406 && this.line2.equals("")) {
            this.line1 = this.line1 + c + "|";
        } else if (this.line2 != "" && this.fm.stringWidth(this.line2 + c + "|") <= 406) {
            this.line2 = this.line2.substring(0, this.line2.length() - 1) + c + "|";
        } else if (this.fm.stringWidth(this.line2 + c + "|") <= 406) {
            this.line1 = this.line1.substring(0, this.line1.length() - 1);
            this.line2 = this.line2 + c + "|";
        }
        this.drawTypeText();
    }

    public void backspace() {
        if (this.line2 != "") {
            try {
                this.line2 = this.line2.substring(0, this.line2.length() - 2) + "|";
                if (this.line2.equals("|")) {
                    this.line2 = "";
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                this.line2 = "";
            }
        } else {
            try {
                this.line1 = this.line1.substring(0, this.line1.length() - 2) + "|";
                if (this.line1.equals("|")) {
                    this.line1 = "";
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                this.line1 = "";
            }
        }
        this.drawTypeText();
    }

    public void OBclear() {
        this.line1 = "";
        this.line2 = "";
        this.drawTypeText();
    }

    public void drawTypeText() {
        this.ttg.setColor(this.dsbg);
        this.ttg.fillRect(0, 0, 406, 26);
        this.ttg.setColor(this.dstext);
        this.ttg.setFont(this.f);
        this.ttg.drawString(this.line1, 1, 10);
        this.ttg.drawString(this.line2, 1, 22);
        this.getGraphics().drawImage(this.typebuffimg, 162, 372, this);
    }

    public boolean lostFocus(Event e, Object what) {
        return true;
    }

    private boolean upPress(Event e) {
        if (e.shiftDown()) {
            this.scrollUp();
            return true;
        }
        return false;
    }

    private boolean downPress(Event e) {
        if (e.shiftDown()) {
            this.scrollDown();
            return true;
        }
        return false;
    }

    private boolean leftPress(Event e) {
        return false;
    }

    private boolean rightPress(Event e) {
        return false;
    }

    public void dialogInput(int c) {
        block0 : switch (this.dialognum) {
            case 0: {
                switch (c) {
                    case 89: 
                    case 121: {
                        this.map.saveMap();
                    }
                    case 78: 
                    case 110: {
                        this.fr.dispose();
                        System.exit(0);
                        break;
                    }
                    case 67: 
                    case 99: {
                        this.closeDialog();
                    }
                }
                break;
            }
            case 1: {
                switch (c) {
                    case 89: 
                    case 121: {
                        this.map.saveMap();
                    }
                    case 78: 
                    case 110: {
                        this.saved = true;
                        this.setupNewMap(this.dialogdata);
                        this.closeDialog();
                    }
                }
                break;
            }
            case 2: {
                switch (c) {
                    case 10: {
                        String tempo = this.line1;
                        tempo = this.line2.equals("") ? tempo.substring(0, tempo.length() - 1) : tempo + this.line2.substring(0, this.line2.length() - 1);
                        this.closeDialog();
                        this.setupNewMap(tempo);
                        this.OBclear();
                        break block0;
                    }
                    case 8: {
                        this.backspace();
                        break block0;
                    }
                }
                if (c <= 31 || c >= 127) break;
                this.append((char)c);
                break;
            }
            case 3: {
                switch (c) {
                    case 89: 
                    case 121: {
                        this.createNewMap(this.dialogdata);
                        this.setupNewMap(this.dialogdata);
                    }
                    case 78: 
                    case 110: {
                        this.closeDialog();
                    }
                }
            }
        }
    }

    public void initDialog(int num, String text, String data) {
        this.dialog = true;
        this.dialognum = num;
        this.dialogtext = text;
        this.dialogdata = data;
        this.append(text);
    }

    public void closeDialog() {
        this.dialog = false;
        this.dialognum = -1;
        this.dialogtext = null;
        this.dialogdata = null;
    }

    public void createNewMap(String thename) {
        this.append("Creating '" + thename + "'...");
        try {
            int y;
            int x;
            RandomAccessFile o = new RandomAccessFile(thename, "rw");
            for (x = 0; x < this.map.mwidth; ++x) {
                for (y = 0; y < this.map.mheight; ++y) {
                    o.writeBytes(this.map.encode(0));
                }
            }
            for (x = 0; x < this.map.mwidth; ++x) {
                for (y = 0; y < this.map.mheight; ++y) {
                    o.writeBytes(this.map.encode(5));
                }
            }
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dataString() {
        this.line1 = "[" + this.map.mapname + "] X=" + this.map.xpos + ",Y=" + this.map.ypos + (this.map.currseltype == 1 ? " item=" + this.map.curritemsel : " floor=" + this.map.currfloorsel);
    }

    public void goThatWay(int dir) {
        if (this.keyhold > 0) {
            --this.keyhold;
            return;
        }
        this.keyhold = 3;
        int nx = this.nextx(this.map.xpos, this.map.ypos, dir);
        int ny = this.nexty(this.map.xpos, this.map.ypos, dir);
        switch (this.map.currseltype) {
            case 1: {
                this.map.itemmap[this.map.xpos][this.map.ypos] = this.t;
                this.t = this.map.itemmap[nx][ny];
                this.map.itemmap[nx][ny] = this.map.curritemsel;
                break;
            }
            case 2: {
                this.map.tilemap[this.map.xpos][this.map.ypos] = this.t;
                this.t = this.map.tilemap[nx][ny];
                this.map.tilemap[nx][ny] = this.map.currfloorsel;
            }
        }
        this.updatePos(nx, ny);
    }
}

