/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class DSEMapCanvas
extends Canvas {
    DSEdit parent;
    Image buffImg;
    Image tileImg;
    int xpos = 26;
    int ypos = 41;
    int isrepaint;
    int currx;
    int curry;
    int xs;
    int xe;
    int ys;
    int ye;
    int oe;
    int tilecount;
    int x;
    int y;
    int inshop = -1;
    int drawok = -1;
    int drawTiles = 1;
    int nitems = 0;
    int curritemsel = 2;
    int currfloorsel = 2;
    int currseltype = 1;
    int t;
    final short mwidth = (short)52;
    final short mheight = (short)100;
    String mapname;
    int[][] tilemap;
    int[][] itemmap;
    int[] tempmap;
    Graphics buffImgG;
    Graphics tileImgG;
    Graphics g;
    Image[] floors;
    Image[] items;
    Image[] playerextra;
    ImageProducer[] player;
    ImageProducer itemsrc;
    ImageProducer flrsrc;
    Hashtable playercache;
    boolean indentline;
    boolean drag;
    byte[] itall = null;
    short[] itemcoords = null;

    public DSEMapCanvas(DSEdit p) {
        this.setBackground(new Color(179, 207, 235));
        this.tilemap = new int[52][100];
        this.itemmap = new int[52][100];
        this.tempmap = new int[132];
        this.parent = p;
        this.floors = new Image[90];
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if (flags == 32) {
            this.repaint();
        }
        return true;
    }

    public void paint(Graphics g) {
        g.drawImage(this.buffImg, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void initMap() {
        if (this.buffImg == null) {
            this.buffImg = this.createImage(385, 256);
            this.buffImgG = this.buffImg.getGraphics();
            this.tileImg = this.createImage(385, 256);
            this.tileImgG = this.tileImg.getGraphics();
            this.g = this.getGraphics();
        }
        for (int i = 0; i < this.tempmap.length; ++i) {
            this.tempmap[i] = -1;
        }
        this.drawTiles = 1;
        this.isrepaint = 0;
        switch (this.currseltype) {
            case 1: {
                this.parent.t = this.itemmap[this.xpos][this.ypos];
                this.itemmap[this.xpos][this.ypos] = this.curritemsel;
                break;
            }
            case 2: {
                this.parent.t = this.tilemap[this.xpos][this.ypos];
                this.tilemap[this.xpos][this.ypos] = this.currfloorsel;
            }
        }
    }

    public void getMapData(String mapname) {
        this.mapname = mapname;
        try {
            int y;
            int x;
            this.parent.append("* Loading map. Please wait. *");
            FileInputStream i = new FileInputStream(mapname);
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    this.tilemap[x][y] = this.decode(i.read(), i.read());
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    this.itemmap[x][y] = this.decode(i.read(), i.read());
                }
            }
            i.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int decode(int head, int tack) {
        return head * 95 + tack;
    }

    public void fetchItemImg(int numnum) {
        this.items[--numnum] = this.doImageCrop(this.itemsrc, this.itemcoords[numnum * 4], this.itemcoords[numnum * 4 + 1], this.itemcoords[numnum * 4 + 2], this.itemcoords[numnum * 4 + 3]);
    }

    public void fetchFloorImg(int numnum) {
        int[] tempo = this.getFloorCoords(numnum);
        this.floors[numnum] = this.doImageCrop(this.flrsrc, tempo[0], tempo[1], 62, 32);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.floors[numnum], 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image doImageCrop(ImageProducer ip, int x, int y, int w, int h) {
        return this.parent.toolkit.createImage(new FilteredImageSource(ip, new CropImageFilter(x, y, w, h)));
    }

    public Image getItem(int item) {
        if (this.items[item - 1] == null) {
            this.fetchItemImg(item);
        }
        return this.items[item - 1];
    }

    public int[] getFloorCoords(int floor) {
        int[] retval = new int[2];
        int column = 0;
        int row = 0;
        block0: for (int r = 1; r <= 10; ++r) {
            for (int c = 1; c <= 9; ++c) {
                if (floor != (r - 1) * 9 + (c - 1)) continue;
                column = c;
                row = r;
                continue block0;
            }
        }
        retval[0] = column + (column - 1) * 62;
        retval[1] = row + (row - 1) * 32;
        return retval;
    }

    public void saveMap() {
        switch (this.currseltype) {
            case 1: {
                this.itemmap[this.xpos][this.ypos] = this.parent.t;
                break;
            }
            case 2: {
                this.tilemap[this.xpos][this.ypos] = this.parent.t;
            }
        }
        try {
            int y;
            int x;
            RandomAccessFile o = new RandomAccessFile(this.mapname, "rw");
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    o.writeBytes(this.encode(this.tilemap[x][y]));
                }
            }
            for (x = 0; x < 52; ++x) {
                for (y = 0; y < 100; ++y) {
                    o.writeBytes(this.encode(this.itemmap[x][y]));
                }
            }
            o.close();
            this.parent.append("Map saved.");
            this.parent.saved = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (this.currseltype) {
            case 1: {
                this.itemmap[this.xpos][this.ypos] = this.curritemsel;
                break;
            }
            case 2: {
                this.tilemap[this.xpos][this.ypos] = this.currfloorsel;
            }
        }
    }

    public String encode(int val) {
        return (char)(val / 95) + "" + (char)(val % 95);
    }

    public void repaint() {
        if (this.drawok == 1 && this.isrepaint == 0) {
            this.isrepaint = 1;
            this.xs = this.xpos - 3;
            this.ys = this.ypos - 8;
            this.xe = this.xpos + 3;
            this.ye = this.ypos + 8;
            this.oe = this.ypos % 2;
            if (this.drawTiles == 1) {
                this.drawTileGraphics();
            }
            this.buffImgG.drawImage(this.tileImg, 0, 0, this);
            this.curry = -16;
            this.indentline = false;
            if (this.oe == 0) {
                this.drawIPEven();
            } else {
                this.drawIPOdd();
            }
            this.g.drawImage(this.buffImg, 0, 0, this);
            this.isrepaint = 0;
        }
    }

    public void drawIPEven() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            if (this.y % 2 != 0) {
                ++this.x;
            }
            while (this.x <= this.xe) {
                this.drawIPSimple();
                this.currx += 64;
                ++this.x;
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawIPOdd() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            while (this.x < this.xe) {
                this.drawIPSimple();
                this.currx += 64;
                ++this.x;
            }
            if (this.y % 2 != 0) {
                this.drawIPSimple();
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawIPSimple() {
        block3: {
            try {
                if (this.itemmap[this.x][this.y] != 0 && this.itemmap[this.x][this.y] < this.items.length) {
                    this.buffImgG.drawImage(this.getItem(this.itemmap[this.x][this.y]), this.currx, this.curry - this.itall[this.itemmap[this.x][this.y]], this);
                }
            }
            catch (Exception e) {
                if (!(e instanceof ArrayIndexOutOfBoundsException)) break block3;
                this.buffImgG.drawImage(this.parent.end, this.currx, this.curry - (this.y > 99 ? 0 : 32), this);
            }
        }
    }

    public void drawTileGraphics() {
        this.tilecount = 0;
        this.curry = -16;
        this.indentline = false;
        if (this.oe == 0) {
            this.drawTileEven();
        } else {
            this.drawTileOdd();
        }
        this.drawTiles = 0;
    }

    public void drawTileEven() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            if (this.y % 2 != 0) {
                ++this.x;
            }
            while (this.x <= this.xe) {
                this.drawTileSimple();
                this.currx += 64;
                ++this.x;
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawTileOdd() {
        this.y = this.ys;
        while (this.y <= this.ye) {
            this.currx = this.indentline ? 1 : -31;
            this.x = this.xs;
            while (this.x < this.xe) {
                this.drawTileSimple();
                this.currx += 64;
                ++this.x;
            }
            if (this.y % 2 != 0) {
                this.drawTileSimple();
            }
            this.curry += 16;
            this.indentline = !this.indentline;
            ++this.y;
        }
    }

    public void drawTileSimple() {
        try {
            if (this.tilemap[this.x][this.y] != this.tempmap[this.tilecount]) {
                if (this.floors[this.tilemap[this.x][this.y]] == null) {
                    this.fetchFloorImg(this.tilemap[this.x][this.y]);
                }
                this.tileImgG.drawImage(this.floors[this.tilemap[this.x][this.y]], this.currx, this.curry, this);
                this.tempmap[this.tilecount] = this.tilemap[this.x][this.y];
            }
        }
        catch (Exception e) {
            this.tempmap[this.tilecount] = -1;
        }
        ++this.tilecount;
    }
}

